/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.server;

import io.opentelemetry.testing.internal.armeria.common.util.UnmodifiableFuture;
import io.opentelemetry.testing.internal.armeria.server.Server;
import io.opentelemetry.testing.internal.armeria.server.UnstoppableScheduledExecutorService;
import io.opentelemetry.testing.internal.armeria.server.logging.AccessLogWriter;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

interface ShutdownSupport {
    public static ShutdownSupport of(AccessLogWriter accessLogWriter) {
        Objects.requireNonNull(accessLogWriter, "accessLogWriter");
        return () -> accessLogWriter.shutdown().exceptionally(cause -> {
            Server.logger.warn("Failed to shutdown the {}:", (Object)accessLogWriter, cause);
            return null;
        });
    }

    public static ShutdownSupport of(ScheduledExecutorService executor) {
        Objects.requireNonNull(executor, "executor");
        return () -> {
            ScheduledExecutorService e = executor instanceof UnstoppableScheduledExecutorService ? ((UnstoppableScheduledExecutorService)executor).getExecutorService() : executor;
            e.shutdown();
            boolean interrupted = false;
            try {
                while (!e.isTerminated()) {
                    try {
                        e.awaitTermination(1L, TimeUnit.HOURS);
                    }
                    catch (InterruptedException ignore) {
                        interrupted = true;
                    }
                }
            }
            catch (Exception cause) {
                Server.logger.warn("Failed to shutdown the {}:", (Object)e, (Object)cause);
            }
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
            return UnmodifiableFuture.completedFuture(null);
        };
    }

    public static ShutdownSupport of(AutoCloseable autoCloseable) {
        Objects.requireNonNull(autoCloseable, "autoCloseable");
        return () -> {
            try {
                autoCloseable.close();
            }
            catch (Exception e) {
                Server.logger.warn("Unexpected exception while closing: {}", (Object)autoCloseable, (Object)e);
            }
            return UnmodifiableFuture.completedFuture(null);
        };
    }

    public CompletableFuture<Void> shutdown();
}

