/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.server;

import io.opentelemetry.testing.internal.armeria.common.HttpMethod;
import io.opentelemetry.testing.internal.armeria.common.RequestHeaders;
import io.opentelemetry.testing.internal.armeria.common.RequestTarget;
import io.opentelemetry.testing.internal.armeria.internal.common.ArmeriaHttpUtil;
import io.opentelemetry.testing.internal.armeria.internal.common.util.ChannelUtil;
import io.opentelemetry.testing.internal.armeria.server.DefaultRoutingContext;
import io.opentelemetry.testing.internal.armeria.server.RoutingContext;
import io.opentelemetry.testing.internal.armeria.server.RoutingStatus;
import io.opentelemetry.testing.internal.armeria.server.ServerConfig;
import io.opentelemetry.testing.internal.io.netty.channel.Channel;

final class ServiceRouteUtil {
    static RoutingContext newRoutingContext(ServerConfig serverConfig, Channel channel, RequestHeaders headers, RequestTarget reqTarget) {
        String hostname = ServiceRouteUtil.hostname(headers);
        int port = ChannelUtil.getPort(channel.localAddress(), 0);
        String originalPath = headers.path();
        RoutingStatus routingStatus = headers.method() == HttpMethod.OPTIONS ? (ArmeriaHttpUtil.isCorsPreflightRequest(headers) ? RoutingStatus.CORS_PREFLIGHT : ("*".equals(originalPath) ? RoutingStatus.OPTIONS : RoutingStatus.OK)) : RoutingStatus.OK;
        return DefaultRoutingContext.of(serverConfig.findVirtualHost(hostname, port), hostname, reqTarget, headers, routingStatus);
    }

    private static String hostname(RequestHeaders headers) {
        String authority = headers.authority();
        assert (authority != null);
        int hostnameColonIdx = authority.lastIndexOf(58);
        if (hostnameColonIdx < 0) {
            return authority;
        }
        return authority.substring(0, hostnameColonIdx);
    }

    private ServiceRouteUtil() {
    }
}

