/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.server;

import com.google.errorprone.annotations.MustBeClosed;
import io.opentelemetry.testing.internal.armeria.client.ClientRequestContext;
import io.opentelemetry.testing.internal.armeria.common.ContextAwareBlockingTaskExecutor;
import io.opentelemetry.testing.internal.armeria.common.ExchangeType;
import io.opentelemetry.testing.internal.armeria.common.HttpHeaders;
import io.opentelemetry.testing.internal.armeria.common.HttpHeadersBuilder;
import io.opentelemetry.testing.internal.armeria.common.HttpRequest;
import io.opentelemetry.testing.internal.armeria.common.MediaType;
import io.opentelemetry.testing.internal.armeria.common.QueryParams;
import io.opentelemetry.testing.internal.armeria.common.RequestContext;
import io.opentelemetry.testing.internal.armeria.common.RpcRequest;
import io.opentelemetry.testing.internal.armeria.common.annotation.Nullable;
import io.opentelemetry.testing.internal.armeria.common.annotation.UnstableApi;
import io.opentelemetry.testing.internal.armeria.common.util.SafeCloseable;
import io.opentelemetry.testing.internal.armeria.common.util.TimeoutMode;
import io.opentelemetry.testing.internal.armeria.internal.common.RequestContextUtil;
import io.opentelemetry.testing.internal.armeria.server.ProxiedAddresses;
import io.opentelemetry.testing.internal.armeria.server.RequestCancellationException;
import io.opentelemetry.testing.internal.armeria.server.RequestTimeoutException;
import io.opentelemetry.testing.internal.armeria.server.RoutingContext;
import io.opentelemetry.testing.internal.armeria.server.ServiceConfig;
import io.opentelemetry.testing.internal.armeria.server.ServiceRequestContextBuilder;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.URI;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nonnull;

public interface ServiceRequestContext
extends RequestContext {
    public static ServiceRequestContext current() {
        Object ctx = RequestContext.current();
        ServiceRequestContext root = ctx.root();
        if (root != null) {
            return root;
        }
        throw new IllegalStateException("The current context is not a server-side context and does not have a root which means that the context is not invoked by a server request. ctx: " + ctx);
    }

    @Nullable
    public static ServiceRequestContext currentOrNull() {
        Object ctx = RequestContext.currentOrNull();
        if (ctx == null) {
            return null;
        }
        return ctx.root();
    }

    @Nullable
    public static <T> T mapCurrent(Function<? super ServiceRequestContext, T> mapper, @Nullable @Nullable Supplier<@Nullable T> defaultValueSupplier) {
        ServiceRequestContext ctx = ServiceRequestContext.currentOrNull();
        if (ctx != null) {
            return mapper.apply(ctx);
        }
        ClientRequestContext clientRequestContext = ClientRequestContext.currentOrNull();
        if (clientRequestContext != null) {
            throw new IllegalStateException("The current context is not a server-side context and does not have a root which means that the context is not invoked by a server request. ctx: " + clientRequestContext);
        }
        if (defaultValueSupplier != null) {
            return defaultValueSupplier.get();
        }
        return null;
    }

    public static ServiceRequestContext of(HttpRequest request) {
        return ServiceRequestContext.builder(request).build();
    }

    public static ServiceRequestContextBuilder builder(HttpRequest request) {
        return new ServiceRequestContextBuilder(request);
    }

    @Override
    @Nonnull
    default public ServiceRequestContext root() {
        return this;
    }

    @Override
    @Nonnull
    public HttpRequest request();

    @Override
    @Nullable
    public RpcRequest rpcRequest();

    @Override
    @Nonnull
    public InetSocketAddress remoteAddress();

    @Override
    @Nonnull
    public InetSocketAddress localAddress();

    public InetAddress clientAddress();

    @Override
    @MustBeClosed
    default public SafeCloseable push() {
        Object oldCtx = RequestContextUtil.getAndSet(this);
        if (oldCtx == null) {
            return RequestContextUtil.invokeHookAndPop(this, null);
        }
        if (oldCtx.unwrapAll() == this.unwrapAll()) {
            return RequestContextUtil.noopSafeCloseable();
        }
        if (RequestContextUtil.equalsIgnoreWrapper(oldCtx.root(), this)) {
            return RequestContextUtil.invokeHookAndPop(this, oldCtx);
        }
        RequestContextUtil.pop(this, oldCtx);
        throw RequestContextUtil.newIllegalContextPushingException(this, oldCtx);
    }

    public ServiceConfig config();

    public RoutingContext routingContext();

    public Map<String, String> pathParams();

    @Nullable
    default public String pathParam(String name) {
        return this.pathParams().get(name);
    }

    public QueryParams queryParams();

    default public List<String> queryParams(String name) {
        return this.queryParams().getAll(name);
    }

    @Nullable
    default public String queryParam(String name) {
        return this.queryParams().get(name);
    }

    public ContextAwareBlockingTaskExecutor blockingTaskExecutor();

    public String mappedPath();

    public String decodedMappedPath();

    @Override
    @UnstableApi
    public URI uri();

    @Nullable
    public MediaType negotiatedResponseMediaType();

    public long requestTimeoutMillis();

    public void clearRequestTimeout();

    default public void setRequestTimeoutMillis(long requestTimeoutMillis) {
        this.setRequestTimeoutMillis(TimeoutMode.SET_FROM_NOW, requestTimeoutMillis);
    }

    public void setRequestTimeoutMillis(TimeoutMode var1, long var2);

    default public void setRequestTimeout(Duration requestTimeout) {
        this.setRequestTimeout(TimeoutMode.SET_FROM_NOW, requestTimeout);
    }

    public void setRequestTimeout(TimeoutMode var1, Duration var2);

    public CompletableFuture<Throwable> whenRequestCancelling();

    public CompletableFuture<Throwable> whenRequestCancelled();

    @Deprecated
    public CompletableFuture<Void> whenRequestTimingOut();

    @Deprecated
    public CompletableFuture<Void> whenRequestTimedOut();

    @Override
    default public void cancel() {
        this.cancel(RequestCancellationException.get());
    }

    @Override
    default public void timeoutNow() {
        this.cancel(RequestTimeoutException.get());
    }

    public long maxRequestLength();

    public void setMaxRequestLength(long var1);

    public HttpHeaders additionalResponseHeaders();

    public void setAdditionalResponseHeader(CharSequence var1, Object var2);

    public void addAdditionalResponseHeader(CharSequence var1, Object var2);

    public void mutateAdditionalResponseHeaders(Consumer<HttpHeadersBuilder> var1);

    public HttpHeaders additionalResponseTrailers();

    public void setAdditionalResponseTrailer(CharSequence var1, Object var2);

    public void addAdditionalResponseTrailer(CharSequence var1, Object var2);

    public void mutateAdditionalResponseTrailers(Consumer<HttpHeadersBuilder> var1);

    public ProxiedAddresses proxiedAddresses();

    public boolean shouldReportUnhandledExceptions();

    public void setShouldReportUnhandledExceptions(boolean var1);

    @UnstableApi
    public CompletableFuture<Void> initiateConnectionShutdown(long var1);

    @UnstableApi
    default public CompletableFuture<Void> initiateConnectionShutdown(Duration drainDuration) {
        Objects.requireNonNull(drainDuration, "drainDuration");
        return this.initiateConnectionShutdown(TimeUnit.NANOSECONDS.toMicros(drainDuration.toNanos()));
    }

    @Override
    @UnstableApi
    public CompletableFuture<Void> initiateConnectionShutdown();

    @Override
    public ExchangeType exchangeType();

    @Override
    default public ServiceRequestContext unwrap() {
        return (ServiceRequestContext)RequestContext.super.unwrap();
    }

    @Override
    default public ServiceRequestContext unwrapAll() {
        return (ServiceRequestContext)RequestContext.super.unwrapAll();
    }
}

