/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.server;

import io.opentelemetry.testing.internal.armeria.common.AggregatedHttpResponse;
import io.opentelemetry.testing.internal.armeria.common.HttpResponse;
import io.opentelemetry.testing.internal.armeria.common.HttpStatus;
import io.opentelemetry.testing.internal.armeria.common.RequestHeaders;
import io.opentelemetry.testing.internal.armeria.common.annotation.Nullable;
import io.opentelemetry.testing.internal.armeria.common.annotation.UnstableApi;
import io.opentelemetry.testing.internal.armeria.server.ServiceConfig;
import io.opentelemetry.testing.internal.armeria.server.ServiceRequestContext;
import java.util.Objects;

@FunctionalInterface
@UnstableApi
public interface ServiceErrorHandler {
    @Nullable
    public HttpResponse onServiceException(ServiceRequestContext var1, Throwable var2);

    @Nullable
    default public AggregatedHttpResponse renderStatus(ServiceConfig config, RequestHeaders headers, HttpStatus status, @Nullable String description, @Nullable Throwable cause) {
        return null;
    }

    default public ServiceErrorHandler orElse(ServiceErrorHandler other) {
        Objects.requireNonNull(other, "other");
        return (ctx, cause) -> {
            HttpResponse response = this.onServiceException(ctx, cause);
            if (response != null) {
                return response;
            }
            return other.onServiceException(ctx, cause);
        };
    }
}

