/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.server;

import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.collect.ImmutableList;
import io.opentelemetry.testing.internal.armeria.server.Server;
import io.opentelemetry.testing.internal.armeria.server.ServerListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;

public final class ServerListenerBuilder {
    private final List<Consumer<? super Server>> serverStartingCallbacks = new ArrayList<Consumer<? super Server>>();
    private final List<Consumer<? super Server>> serverStartedCallbacks = new ArrayList<Consumer<? super Server>>();
    private final List<Consumer<? super Server>> serverStoppingCallbacks = new ArrayList<Consumer<? super Server>>();
    private final List<Consumer<? super Server>> serverStoppedCallbacks = new ArrayList<Consumer<? super Server>>();

    ServerListenerBuilder() {
    }

    public ServerListenerBuilder whenStarting(Consumer<? super Server> consumer) {
        this.serverStartingCallbacks.add(Objects.requireNonNull(consumer, "consumer"));
        return this;
    }

    @SafeVarargs
    public final ServerListenerBuilder whenStarting(Consumer<? super Server> ... consumers) {
        return this.whenStarting(Arrays.asList(consumers));
    }

    public ServerListenerBuilder whenStarting(Iterable<? extends Consumer<? super Server>> consumers) {
        Objects.requireNonNull(consumers, "consumers");
        for (Consumer<? super Server> consumer : consumers) {
            this.serverStartingCallbacks.add(Objects.requireNonNull(consumer, "consumer"));
        }
        return this;
    }

    public ServerListenerBuilder whenStarted(Consumer<? super Server> consumer) {
        this.serverStartedCallbacks.add(Objects.requireNonNull(consumer, "consumer"));
        return this;
    }

    @SafeVarargs
    public final ServerListenerBuilder whenStarted(Consumer<? super Server> ... consumers) {
        return this.whenStarted(Arrays.asList(consumers));
    }

    public ServerListenerBuilder whenStarted(Iterable<? extends Consumer<? super Server>> consumers) {
        Objects.requireNonNull(consumers, "consumers");
        for (Consumer<? super Server> consumer : consumers) {
            this.serverStartedCallbacks.add(Objects.requireNonNull(consumer, "consumer"));
        }
        return this;
    }

    public ServerListenerBuilder whenStopping(Consumer<? super Server> consumer) {
        this.serverStoppingCallbacks.add(Objects.requireNonNull(consumer, "consumer"));
        return this;
    }

    @SafeVarargs
    public final ServerListenerBuilder whenStopping(Consumer<? super Server> ... consumers) {
        return this.whenStopping(Arrays.asList(consumers));
    }

    public ServerListenerBuilder whenStopping(Iterable<? extends Consumer<? super Server>> consumers) {
        Objects.requireNonNull(consumers, "consumers");
        for (Consumer<? super Server> consumer : consumers) {
            this.serverStoppingCallbacks.add(Objects.requireNonNull(consumer, "consumer"));
        }
        return this;
    }

    public ServerListenerBuilder whenStopped(Consumer<? super Server> consumer) {
        this.serverStoppedCallbacks.add(Objects.requireNonNull(consumer, "consumer"));
        return this;
    }

    @SafeVarargs
    public final ServerListenerBuilder whenStopped(Consumer<? super Server> ... consumers) {
        return this.whenStopped(Arrays.asList(consumers));
    }

    public ServerListenerBuilder whenStopped(Iterable<? extends Consumer<? super Server>> consumers) {
        Objects.requireNonNull(consumers, "consumers");
        for (Consumer<? super Server> consumer : consumers) {
            this.serverStoppedCallbacks.add(Objects.requireNonNull(consumer, "consumer"));
        }
        return this;
    }

    public ServerListener build() {
        return new CallbackServerListener(this.serverStartingCallbacks, this.serverStartedCallbacks, this.serverStoppingCallbacks, this.serverStoppedCallbacks);
    }

    private static class CallbackServerListener
    implements ServerListener {
        private final List<Consumer<? super Server>> serverStartingCallbacks;
        private final List<Consumer<? super Server>> serverStartedCallbacks;
        private final List<Consumer<? super Server>> serverStoppingCallbacks;
        private final List<Consumer<? super Server>> serverStoppedCallbacks;

        CallbackServerListener(List<Consumer<? super Server>> serverStartingCallbacks, List<Consumer<? super Server>> serverStartedCallbacks, List<Consumer<? super Server>> serverStoppingCallbacks, List<Consumer<? super Server>> serverStoppedCallbacks) {
            this.serverStartingCallbacks = ImmutableList.copyOf(serverStartingCallbacks);
            this.serverStartedCallbacks = ImmutableList.copyOf(serverStartedCallbacks);
            this.serverStoppingCallbacks = ImmutableList.copyOf(serverStoppingCallbacks);
            this.serverStoppedCallbacks = ImmutableList.copyOf(serverStoppedCallbacks);
        }

        @Override
        public void serverStarting(Server server) {
            for (Consumer<? super Server> serverStartingCallback : this.serverStartingCallbacks) {
                serverStartingCallback.accept(server);
            }
        }

        @Override
        public void serverStarted(Server server) {
            for (Consumer<? super Server> serverStartedCallback : this.serverStartedCallbacks) {
                serverStartedCallback.accept(server);
            }
        }

        @Override
        public void serverStopping(Server server) {
            for (Consumer<? super Server> serverStoppingCallback : this.serverStoppingCallbacks) {
                serverStoppingCallback.accept(server);
            }
        }

        @Override
        public void serverStopped(Server server) {
            for (Consumer<? super Server> serverStoppedCallback : this.serverStoppedCallbacks) {
                serverStoppedCallback.accept(server);
            }
        }
    }
}

