/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.server;

import io.opentelemetry.testing.internal.armeria.common.AggregatedHttpResponse;
import io.opentelemetry.testing.internal.armeria.common.HttpResponse;
import io.opentelemetry.testing.internal.armeria.common.HttpStatus;
import io.opentelemetry.testing.internal.armeria.common.RequestHeaders;
import io.opentelemetry.testing.internal.armeria.common.annotation.Nullable;
import io.opentelemetry.testing.internal.armeria.common.annotation.UnstableApi;
import io.opentelemetry.testing.internal.armeria.server.DefaultServerErrorHandler;
import io.opentelemetry.testing.internal.armeria.server.ServiceConfig;
import io.opentelemetry.testing.internal.armeria.server.ServiceErrorHandler;
import io.opentelemetry.testing.internal.armeria.server.ServiceRequestContext;
import java.util.Objects;

@FunctionalInterface
@UnstableApi
public interface ServerErrorHandler {
    public static ServerErrorHandler ofDefault() {
        return DefaultServerErrorHandler.INSTANCE;
    }

    @Nullable
    public HttpResponse onServiceException(ServiceRequestContext var1, Throwable var2);

    @Nullable
    default public AggregatedHttpResponse onProtocolViolation(ServiceConfig config, @Nullable RequestHeaders headers, HttpStatus status, @Nullable String description, @Nullable Throwable cause) {
        return this.renderStatus(config, headers, status, description, cause);
    }

    @Nullable
    default public AggregatedHttpResponse renderStatus(ServiceConfig config, @Nullable RequestHeaders headers, HttpStatus status, @Nullable String description, @Nullable Throwable cause) {
        return null;
    }

    default public ServerErrorHandler orElse(final ServerErrorHandler other) {
        Objects.requireNonNull(other, "other");
        return new ServerErrorHandler(){

            @Override
            @Nullable
            public HttpResponse onServiceException(ServiceRequestContext ctx, Throwable cause) {
                HttpResponse response = ServerErrorHandler.this.onServiceException(ctx, cause);
                if (response != null) {
                    return response;
                }
                return other.onServiceException(ctx, cause);
            }

            @Override
            @Nullable
            public AggregatedHttpResponse onProtocolViolation(ServiceConfig config, @Nullable RequestHeaders headers, HttpStatus status, @Nullable String description, @Nullable Throwable cause) {
                AggregatedHttpResponse response = ServerErrorHandler.this.onProtocolViolation(config, headers, status, description, cause);
                if (response != null) {
                    return response;
                }
                return other.onProtocolViolation(config, headers, status, description, cause);
            }

            @Override
            @Nullable
            public AggregatedHttpResponse renderStatus(ServiceConfig config, @Nullable RequestHeaders headers, HttpStatus status, @Nullable String description, @Nullable Throwable cause) {
                AggregatedHttpResponse response = ServerErrorHandler.this.renderStatus(config, headers, status, description, cause);
                if (response != null) {
                    return response;
                }
                return other.renderStatus(config, headers, status, description, cause);
            }
        };
    }

    default public ServiceErrorHandler asServiceErrorHandler() {
        return new ServiceErrorHandler(){

            @Override
            @Nullable
            public HttpResponse onServiceException(ServiceRequestContext ctx, Throwable cause) {
                return ServerErrorHandler.this.onServiceException(ctx, cause);
            }

            @Override
            @Nullable
            public AggregatedHttpResponse renderStatus(ServiceConfig config, @Nullable RequestHeaders headers, HttpStatus status, @Nullable String description, @Nullable Throwable cause) {
                return ServerErrorHandler.this.renderStatus(config, headers, status, description, cause);
            }
        };
    }
}

