/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.server;

import io.opentelemetry.testing.internal.armeria.common.Flags;
import io.opentelemetry.testing.internal.armeria.common.annotation.Nullable;
import io.opentelemetry.testing.internal.armeria.internal.common.ArmeriaHttpUtil;
import io.opentelemetry.testing.internal.armeria.internal.server.RouteUtil;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.base.Preconditions;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.collect.ImmutableList;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.collect.ImmutableSet;
import io.opentelemetry.testing.internal.armeria.server.AbstractPathMapping;
import io.opentelemetry.testing.internal.armeria.server.PathMapping;
import io.opentelemetry.testing.internal.armeria.server.RoutePathType;
import io.opentelemetry.testing.internal.armeria.server.RoutingContext;
import io.opentelemetry.testing.internal.armeria.server.RoutingResult;
import io.opentelemetry.testing.internal.armeria.server.RoutingResultBuilder;
import java.util.List;
import java.util.Set;

final class PrefixPathMapping
extends AbstractPathMapping {
    private final String prefix;
    private final boolean stripPrefix;
    private final List<String> paths;
    private final String pathPattern;
    private final String strVal;

    PrefixPathMapping(String prefix, boolean stripPrefix) {
        Preconditions.checkArgument(Flags.allowSemicolonInPathComponent() || prefix.indexOf(59) < 0, "prefix: %s (expected not to have a ';')", (Object)prefix);
        prefix = RouteUtil.ensureAbsolutePath(prefix, "prefix");
        if (!prefix.endsWith("/")) {
            prefix = prefix + '/';
        }
        this.prefix = prefix;
        this.stripPrefix = stripPrefix;
        String triePath = prefix + '*';
        this.paths = ImmutableList.of(prefix, triePath);
        this.pathPattern = triePath;
        this.strVal = "prefix:" + prefix + " (stripPrefix: " + stripPrefix + ')';
    }

    @Override
    PathMapping doWithPrefix(String prefix) {
        return new PrefixPathMapping(ArmeriaHttpUtil.concatPaths(prefix, this.prefix), this.stripPrefix);
    }

    @Override
    @Nullable
    RoutingResultBuilder doApply(RoutingContext routingCtx) {
        String path = routingCtx.path();
        if (!path.startsWith(this.prefix)) {
            return null;
        }
        return RoutingResult.builder().path(this.stripPrefix ? path.substring(this.prefix.length() - 1) : path).query(routingCtx.query());
    }

    @Override
    public Set<String> paramNames() {
        return ImmutableSet.of();
    }

    @Override
    public String patternString() {
        return this.pathPattern;
    }

    @Override
    public RoutePathType pathType() {
        return RoutePathType.PREFIX;
    }

    @Override
    public List<String> paths() {
        return this.paths;
    }

    public int hashCode() {
        return this.stripPrefix ? this.prefix.hashCode() : -this.prefix.hashCode();
    }

    public boolean equals(@Nullable Object obj) {
        if (!(obj instanceof PrefixPathMapping)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        PrefixPathMapping that = (PrefixPathMapping)obj;
        return this.stripPrefix == that.stripPrefix && this.prefix.equals(that.prefix);
    }

    @Override
    public String toString() {
        return this.strVal;
    }
}

