/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.server;

import io.opentelemetry.testing.internal.armeria.internal.common.util.TargetLengthBasedClassNameAbbreviator;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.base.Preconditions;
import io.opentelemetry.testing.internal.armeria.server.ServiceNaming;
import io.opentelemetry.testing.internal.armeria.server.ServiceRequestContext;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

final class LengthBasedServiceNaming
implements ServiceNaming {
    private final TargetLengthBasedClassNameAbbreviator abbreviator;
    private final ConcurrentMap<String, String> cache = new ConcurrentHashMap<String, String>();

    static LengthBasedServiceNaming of(int shortenedServiceNameLength) {
        return new LengthBasedServiceNaming(shortenedServiceNameLength);
    }

    private LengthBasedServiceNaming(int shortenedServiceNameLength) {
        Preconditions.checkArgument(shortenedServiceNameLength >= 0, "value: %s (expected >= 0)", shortenedServiceNameLength);
        this.abbreviator = new TargetLengthBasedClassNameAbbreviator(shortenedServiceNameLength);
    }

    @Override
    public String serviceName(ServiceRequestContext ctx) {
        String fullTypeName = ServiceNaming.fullTypeName().serviceName(ctx);
        return this.abbreviate(fullTypeName);
    }

    private String abbreviate(String serviceName) {
        String abbreviation = (String)this.cache.get(serviceName);
        if (abbreviation != null) {
            return abbreviation;
        }
        return this.cache.computeIfAbsent(serviceName, this.abbreviator::abbreviate);
    }
}

