/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.server;

import io.opentelemetry.testing.internal.armeria.common.AggregatedHttpResponse;
import io.opentelemetry.testing.internal.armeria.common.ExchangeType;
import io.opentelemetry.testing.internal.armeria.common.HttpHeaderNames;
import io.opentelemetry.testing.internal.armeria.common.HttpRequest;
import io.opentelemetry.testing.internal.armeria.common.HttpResponse;
import io.opentelemetry.testing.internal.armeria.common.HttpStatus;
import io.opentelemetry.testing.internal.armeria.common.ResponseHeaders;
import io.opentelemetry.testing.internal.armeria.server.HttpService;
import io.opentelemetry.testing.internal.armeria.server.HttpStatusException;
import io.opentelemetry.testing.internal.armeria.server.RoutingContext;
import io.opentelemetry.testing.internal.armeria.server.RoutingStatus;
import io.opentelemetry.testing.internal.armeria.server.ServiceErrorHandler;
import io.opentelemetry.testing.internal.armeria.server.ServiceRequestContext;

final class FallbackService
implements HttpService {
    static final FallbackService INSTANCE = new FallbackService();

    private FallbackService() {
    }

    @Override
    public HttpResponse serve(ServiceRequestContext ctx, HttpRequest req) throws Exception {
        RoutingContext routingCtx = ctx.routingContext();
        if (routingCtx.status() == RoutingStatus.CORS_PREFLIGHT) {
            return FallbackService.newFallbackResponse(ctx, HttpStatus.FORBIDDEN);
        }
        HttpStatusException cause = routingCtx.deferredStatusException();
        if (cause == null || cause.httpStatus() == HttpStatus.NOT_FOUND) {
            return FallbackService.handleNotFound(ctx, routingCtx);
        }
        return FallbackService.newFallbackResponse(ctx, cause.httpStatus());
    }

    @Override
    public ExchangeType exchangeType(RoutingContext routingContext) {
        return ExchangeType.REQUEST_STREAMING;
    }

    private static HttpResponse handleNotFound(ServiceRequestContext ctx, RoutingContext routingCtx) {
        String oldPath = routingCtx.path();
        if (oldPath.charAt(oldPath.length() - 1) == '/') {
            return FallbackService.newFallbackResponse(ctx, HttpStatus.NOT_FOUND);
        }
        if (!ctx.config().virtualHost().findServiceConfig(routingCtx.withPath(oldPath + '/')).isPresent()) {
            return FallbackService.newFallbackResponse(ctx, HttpStatus.NOT_FOUND);
        }
        int index = oldPath.lastIndexOf(47);
        assert (index >= 0);
        String location = oldPath.substring(index + 1) + '/';
        if (routingCtx.query() != null) {
            location = location + '?' + routingCtx.query();
        }
        return HttpResponse.of(ResponseHeaders.builder(HttpStatus.TEMPORARY_REDIRECT).add((CharSequence)HttpHeaderNames.LOCATION, location).build());
    }

    private static HttpResponse newFallbackResponse(ServiceRequestContext ctx, HttpStatus status) {
        ServiceErrorHandler errorHandler = ctx.config().errorHandler();
        AggregatedHttpResponse rendered = errorHandler.renderStatus(ctx.config(), ctx.request().headers(), status, null, null);
        if (rendered != null) {
            return rendered.toHttpResponse();
        }
        return HttpResponse.of(ResponseHeaders.builder(status).endOfStream(true).build());
    }
}

