/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.server;

import io.opentelemetry.testing.internal.armeria.common.AggregatedHttpResponse;
import io.opentelemetry.testing.internal.armeria.common.HttpResponse;
import io.opentelemetry.testing.internal.armeria.common.HttpStatus;
import io.opentelemetry.testing.internal.armeria.common.RequestHeaders;
import io.opentelemetry.testing.internal.armeria.common.annotation.Nullable;
import io.opentelemetry.testing.internal.armeria.common.util.Exceptions;
import io.opentelemetry.testing.internal.armeria.server.HttpResponseException;
import io.opentelemetry.testing.internal.armeria.server.HttpStatusException;
import io.opentelemetry.testing.internal.armeria.server.ServiceConfig;
import io.opentelemetry.testing.internal.armeria.server.ServiceErrorHandler;
import io.opentelemetry.testing.internal.armeria.server.ServiceRequestContext;
import io.opentelemetry.testing.internal.armeria.server.UnhandledExceptionsReporter;

final class ExceptionReportingServiceErrorHandler
implements ServiceErrorHandler {
    private final ServiceErrorHandler delegate;
    private final UnhandledExceptionsReporter reporter;

    ExceptionReportingServiceErrorHandler(ServiceErrorHandler delegate, UnhandledExceptionsReporter reporter) {
        this.delegate = delegate;
        this.reporter = reporter;
    }

    @Override
    @Nullable
    public HttpResponse onServiceException(ServiceRequestContext ctx, Throwable cause) {
        if (ctx.shouldReportUnhandledExceptions() && !ExceptionReportingServiceErrorHandler.isIgnorableException(cause)) {
            this.reporter.report(cause);
        }
        return this.delegate.onServiceException(ctx, cause);
    }

    private static boolean isIgnorableException(Throwable cause) {
        if (Exceptions.isExpected(cause)) {
            return true;
        }
        return (cause instanceof HttpStatusException || cause instanceof HttpResponseException) && cause.getCause() == null;
    }

    @Override
    @Nullable
    public AggregatedHttpResponse renderStatus(ServiceConfig config, @Nullable RequestHeaders headers, HttpStatus status, @Nullable String description, @Nullable Throwable cause) {
        return this.delegate.renderStatus(config, headers, status, description, cause);
    }
}

