/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.server;

import io.opentelemetry.testing.internal.armeria.common.Flags;
import io.opentelemetry.testing.internal.armeria.common.annotation.Nullable;
import io.opentelemetry.testing.internal.armeria.internal.common.ArmeriaHttpUtil;
import io.opentelemetry.testing.internal.armeria.internal.server.RouteUtil;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.base.Preconditions;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.collect.ImmutableList;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.collect.ImmutableSet;
import io.opentelemetry.testing.internal.armeria.server.AbstractPathMapping;
import io.opentelemetry.testing.internal.armeria.server.PathMapping;
import io.opentelemetry.testing.internal.armeria.server.RoutePathType;
import io.opentelemetry.testing.internal.armeria.server.RoutingContext;
import io.opentelemetry.testing.internal.armeria.server.RoutingResult;
import io.opentelemetry.testing.internal.armeria.server.RoutingResultBuilder;
import java.util.List;
import java.util.Set;

final class ExactPathMapping
extends AbstractPathMapping {
    private final String prefix;
    private final String exactPath;
    private final List<String> paths;

    ExactPathMapping(String exactPath) {
        this("", exactPath);
    }

    private ExactPathMapping(String prefix, String exactPath) {
        if (!Flags.allowSemicolonInPathComponent()) {
            Preconditions.checkArgument(prefix.indexOf(59) < 0, "prefix: %s (expected not to have a ';')", (Object)prefix);
            Preconditions.checkArgument(exactPath.indexOf(59) < 0, "exactPath: %s (expected not to have a ';')", (Object)exactPath);
        }
        this.prefix = prefix;
        this.exactPath = RouteUtil.ensureAbsolutePath(exactPath, "exactPath");
        this.paths = ImmutableList.of(exactPath, exactPath);
    }

    @Override
    PathMapping doWithPrefix(String prefix) {
        return new ExactPathMapping(prefix, ArmeriaHttpUtil.concatPaths(prefix, this.exactPath));
    }

    @Override
    @Nullable
    RoutingResultBuilder doApply(RoutingContext routingCtx) {
        return this.exactPath.equals(routingCtx.path()) ? RoutingResult.builder().path(ExactPathMapping.mappedPath(this.prefix, routingCtx.path())).query(routingCtx.query()) : null;
    }

    @Override
    public Set<String> paramNames() {
        return ImmutableSet.of();
    }

    @Override
    public String patternString() {
        return this.exactPath;
    }

    @Override
    public RoutePathType pathType() {
        return RoutePathType.EXACT;
    }

    @Override
    public List<String> paths() {
        return this.paths;
    }

    public int hashCode() {
        return this.exactPath.hashCode();
    }

    public boolean equals(@Nullable Object obj) {
        return obj instanceof ExactPathMapping && (this == obj || this.exactPath.equals(((ExactPathMapping)obj).exactPath));
    }
}

