/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.server;

import io.opentelemetry.testing.internal.armeria.common.ExchangeType;
import io.opentelemetry.testing.internal.armeria.common.HttpRequest;
import io.opentelemetry.testing.internal.armeria.common.HttpResponse;
import io.opentelemetry.testing.internal.armeria.common.RequestHeaders;
import io.opentelemetry.testing.internal.armeria.common.annotation.Nullable;
import io.opentelemetry.testing.internal.armeria.common.util.SystemInfo;
import io.opentelemetry.testing.internal.armeria.internal.common.InboundTrafficController;
import io.opentelemetry.testing.internal.armeria.server.AggregatingDecodedHttpRequest;
import io.opentelemetry.testing.internal.armeria.server.EmptyContentDecodedHttpRequest;
import io.opentelemetry.testing.internal.armeria.server.HttpService;
import io.opentelemetry.testing.internal.armeria.server.Routed;
import io.opentelemetry.testing.internal.armeria.server.RoutingContext;
import io.opentelemetry.testing.internal.armeria.server.ServiceConfig;
import io.opentelemetry.testing.internal.armeria.server.ServiceRequestContext;
import io.opentelemetry.testing.internal.armeria.server.StreamingDecodedHttpRequest;
import io.opentelemetry.testing.internal.io.netty.channel.EventLoop;

interface DecodedHttpRequest
extends HttpRequest {
    public static DecodedHttpRequest of(boolean endOfStream, EventLoop eventLoop, int id, int streamId, RequestHeaders headers, boolean keepAlive, InboundTrafficController inboundTrafficController, RoutingContext routingCtx) {
        long requestStartTimeNanos = System.nanoTime();
        long requestStartTimeMicros = SystemInfo.currentTimeMicros();
        if (!routingCtx.hasResult()) {
            return new EmptyContentDecodedHttpRequest(eventLoop, id, streamId, headers, keepAlive, routingCtx, ExchangeType.RESPONSE_STREAMING, requestStartTimeNanos, requestStartTimeMicros);
        }
        ServiceConfig config = routingCtx.result().value();
        HttpService service = config.service();
        ExchangeType exchangeType = service.exchangeType(routingCtx);
        if (endOfStream) {
            return new EmptyContentDecodedHttpRequest(eventLoop, id, streamId, headers, keepAlive, routingCtx, exchangeType, requestStartTimeNanos, requestStartTimeMicros);
        }
        if (exchangeType.isRequestStreaming()) {
            return new StreamingDecodedHttpRequest(eventLoop, id, streamId, headers, keepAlive, inboundTrafficController, config.maxRequestLength(), routingCtx, exchangeType, requestStartTimeNanos, requestStartTimeMicros, false);
        }
        return new AggregatingDecodedHttpRequest(eventLoop, id, streamId, headers, keepAlive, config.maxRequestLength(), routingCtx, exchangeType, requestStartTimeNanos, requestStartTimeMicros);
    }

    public int id();

    public int streamId();

    public boolean isKeepAlive();

    public void init(ServiceRequestContext var1);

    public RoutingContext routingContext();

    @Nullable
    public Routed<ServiceConfig> route();

    public void close();

    public void close(Throwable var1);

    public void setResponse(HttpResponse var1);

    public void abortResponse(Throwable var1, boolean var2);

    public boolean needsAggregation();

    public ExchangeType exchangeType();

    public long requestStartTimeNanos();

    public long requestStartTimeMicros();

    default public boolean isHttp1WebSocket() {
        return false;
    }
}

