/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.server;

import io.opentelemetry.testing.internal.armeria.common.HttpRequest;
import io.opentelemetry.testing.internal.armeria.common.HttpResponse;
import io.opentelemetry.testing.internal.armeria.common.HttpStatus;
import io.opentelemetry.testing.internal.armeria.server.HttpService;
import io.opentelemetry.testing.internal.armeria.server.ServiceRequestContext;

public abstract class AbstractHttpService
implements HttpService {
    @Override
    public final HttpResponse serve(ServiceRequestContext ctx, HttpRequest req) throws Exception {
        switch (req.method()) {
            case OPTIONS: {
                return this.doOptions(ctx, req);
            }
            case GET: {
                return this.doGet(ctx, req);
            }
            case HEAD: {
                return this.doHead(ctx, req);
            }
            case POST: {
                return this.doPost(ctx, req);
            }
            case PUT: {
                return this.doPut(ctx, req);
            }
            case PATCH: {
                return this.doPatch(ctx, req);
            }
            case DELETE: {
                return this.doDelete(ctx, req);
            }
            case TRACE: {
                return this.doTrace(ctx, req);
            }
            case CONNECT: {
                return this.doConnect(ctx, req);
            }
        }
        return HttpResponse.of(HttpStatus.METHOD_NOT_ALLOWED);
    }

    protected HttpResponse doOptions(ServiceRequestContext ctx, HttpRequest req) throws Exception {
        return HttpResponse.of(HttpStatus.METHOD_NOT_ALLOWED);
    }

    protected HttpResponse doGet(ServiceRequestContext ctx, HttpRequest req) throws Exception {
        return HttpResponse.of(HttpStatus.METHOD_NOT_ALLOWED);
    }

    protected HttpResponse doHead(ServiceRequestContext ctx, HttpRequest req) throws Exception {
        return HttpResponse.of(HttpStatus.METHOD_NOT_ALLOWED);
    }

    protected HttpResponse doPost(ServiceRequestContext ctx, HttpRequest req) throws Exception {
        return HttpResponse.of(HttpStatus.METHOD_NOT_ALLOWED);
    }

    protected HttpResponse doPut(ServiceRequestContext ctx, HttpRequest req) throws Exception {
        return HttpResponse.of(HttpStatus.METHOD_NOT_ALLOWED);
    }

    protected HttpResponse doPatch(ServiceRequestContext ctx, HttpRequest req) throws Exception {
        return HttpResponse.of(HttpStatus.METHOD_NOT_ALLOWED);
    }

    protected HttpResponse doDelete(ServiceRequestContext ctx, HttpRequest req) throws Exception {
        return HttpResponse.of(HttpStatus.METHOD_NOT_ALLOWED);
    }

    protected HttpResponse doTrace(ServiceRequestContext ctx, HttpRequest req) throws Exception {
        return HttpResponse.of(HttpStatus.METHOD_NOT_ALLOWED);
    }

    protected HttpResponse doConnect(ServiceRequestContext ctx, HttpRequest req) throws Exception {
        return HttpResponse.of(HttpStatus.METHOD_NOT_ALLOWED);
    }
}

