/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.internal.testing;

import io.opentelemetry.testing.internal.armeria.common.annotation.Nullable;
import io.opentelemetry.testing.internal.armeria.common.util.EventLoopGroups;
import io.opentelemetry.testing.internal.io.netty.channel.EventLoopGroup;
import java.util.concurrent.ThreadFactory;

public final class EventLoopGroupRuleDelegate {
    private final int numThreads;
    private final ThreadFactory threadFactory;
    @Nullable
    private volatile EventLoopGroup group;

    public EventLoopGroupRuleDelegate(int numThreads, ThreadFactory threadFactory) {
        this.numThreads = numThreads;
        this.threadFactory = threadFactory;
    }

    public EventLoopGroup group() {
        EventLoopGroup group = this.group;
        if (group == null) {
            throw new IllegalStateException(EventLoopGroup.class.getSimpleName() + " not initialized");
        }
        return group;
    }

    public void before() throws Throwable {
        this.group = EventLoopGroups.newEventLoopGroup(this.numThreads, this.threadFactory);
    }

    public void after() {
        EventLoopGroup group = this.group;
        if (group != null) {
            this.group = null;
            group.shutdownGracefully();
        }
    }
}

