/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.internal.shaded.fastutil.doubles;

import io.opentelemetry.testing.internal.armeria.internal.shaded.fastutil.Arrays;
import io.opentelemetry.testing.internal.armeria.internal.shaded.fastutil.Hash;
import io.opentelemetry.testing.internal.armeria.internal.shaded.fastutil.doubles.DoubleComparator;
import java.io.Serializable;

public final class DoubleArrays {
    public static final double[] EMPTY_ARRAY = new double[0];
    public static final double[] DEFAULT_EMPTY_ARRAY = new double[0];
    protected static final Segment POISON_PILL = new Segment(-1, -1, -1);
    public static final Hash.Strategy<double[]> HASH_STRATEGY = new ArrayHashStrategy();

    public static void ensureOffsetLength(double[] a, int offset, int length) {
        Arrays.ensureOffsetLength(a.length, offset, length);
    }

    private static void insertionSort(double[] a, int from, int to, DoubleComparator comp) {
        int i = from;
        while (++i < to) {
            double t = a[i];
            int j = i;
            double u = a[j - 1];
            while (comp.compare(t, u) < 0) {
                a[j] = u;
                if (from == j - 1) {
                    --j;
                    break;
                }
                u = a[--j - 1];
            }
            a[j] = t;
        }
    }

    private static void insertionSort(double[] a, int from, int to) {
        int i = from;
        while (++i < to) {
            double t = a[i];
            int j = i;
            double u = a[j - 1];
            while (Double.compare(t, u) < 0) {
                a[j] = u;
                if (from == j - 1) {
                    --j;
                    break;
                }
                u = a[--j - 1];
            }
            a[j] = t;
        }
    }

    public static void mergeSort(double[] a, int from, int to, double[] supp) {
        int len = to - from;
        if (len < 16) {
            DoubleArrays.insertionSort(a, from, to);
            return;
        }
        if (supp == null) {
            supp = java.util.Arrays.copyOf(a, to);
        }
        int mid = from + to >>> 1;
        DoubleArrays.mergeSort(supp, from, mid, a);
        DoubleArrays.mergeSort(supp, mid, to, a);
        if (Double.compare(supp[mid - 1], supp[mid]) <= 0) {
            System.arraycopy(supp, from, a, from, len);
            return;
        }
        int p = from;
        int q = mid;
        for (int i = from; i < to; ++i) {
            a[i] = q >= to || p < mid && Double.compare(supp[p], supp[q]) <= 0 ? supp[p++] : supp[q++];
        }
    }

    public static void mergeSort(double[] a, int from, int to) {
        DoubleArrays.mergeSort(a, from, to, (double[])null);
    }

    public static void mergeSort(double[] a, int from, int to, DoubleComparator comp, double[] supp) {
        int len = to - from;
        if (len < 16) {
            DoubleArrays.insertionSort(a, from, to, comp);
            return;
        }
        if (supp == null) {
            supp = java.util.Arrays.copyOf(a, to);
        }
        int mid = from + to >>> 1;
        DoubleArrays.mergeSort(supp, from, mid, comp, a);
        DoubleArrays.mergeSort(supp, mid, to, comp, a);
        if (comp.compare(supp[mid - 1], supp[mid]) <= 0) {
            System.arraycopy(supp, from, a, from, len);
            return;
        }
        int p = from;
        int q = mid;
        for (int i = from; i < to; ++i) {
            a[i] = q >= to || p < mid && comp.compare(supp[p], supp[q]) <= 0 ? supp[p++] : supp[q++];
        }
    }

    public static void mergeSort(double[] a, int from, int to, DoubleComparator comp) {
        DoubleArrays.mergeSort(a, from, to, comp, null);
    }

    public static void stableSort(double[] a, int from, int to) {
        DoubleArrays.mergeSort(a, from, to);
    }

    public static void stableSort(double[] a) {
        DoubleArrays.stableSort(a, 0, a.length);
    }

    public static void stableSort(double[] a, int from, int to, DoubleComparator comp) {
        DoubleArrays.mergeSort(a, from, to, comp);
    }

    public static void stableSort(double[] a, DoubleComparator comp) {
        DoubleArrays.stableSort(a, 0, a.length, comp);
    }

    protected static final class Segment {
        protected final int offset;
        protected final int length;
        protected final int level;

        protected Segment(int offset, int length, int level) {
            this.offset = offset;
            this.length = length;
            this.level = level;
        }

        public String toString() {
            return "Segment [offset=" + this.offset + ", length=" + this.length + ", level=" + this.level + "]";
        }
    }

    private static final class ArrayHashStrategy
    implements Hash.Strategy<double[]>,
    Serializable {
        private ArrayHashStrategy() {
        }

        @Override
        public int hashCode(double[] o) {
            return java.util.Arrays.hashCode(o);
        }

        @Override
        public boolean equals(double[] a, double[] b) {
            return java.util.Arrays.equals(a, b);
        }
    }
}

