/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.util;

import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.math.raw.Mod;
import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.math.raw.Nat;
import java.math.BigInteger;
import java.security.SecureRandom;

public final class BigIntegers {
    public static final BigInteger ZERO = BigInteger.valueOf(0L);
    public static final BigInteger ONE = BigInteger.valueOf(1L);
    public static final BigInteger TWO = BigInteger.valueOf(2L);
    private static final BigInteger THREE = BigInteger.valueOf(3L);
    private static final BigInteger SMALL_PRIMES_PRODUCT = new BigInteger("8138e8a0fcf3a4e84a771d40fd305d7f4aa59306d7251de54d98af8fe95729a1f73d893fa424cd2edc8636a6c3285e022b0e3866a565ae8108eed8591cd4fe8d2ce86165a978d719ebf647f362d33fca29cd179fb42401cbaf3df0c614056f9c8f3cfd51e474afb6bc6974f78db8aba8e9e517fded658591ab7502bd41849462f", 16);
    private static final int MAX_SMALL = BigInteger.valueOf(743L).bitLength();

    public static byte[] asUnsignedByteArray(int n, BigInteger bigInteger) {
        byte[] byArray = bigInteger.toByteArray();
        if (byArray.length == n) {
            return byArray;
        }
        int n2 = byArray[0] == 0 && byArray.length != 1 ? 1 : 0;
        int n3 = byArray.length - n2;
        if (n3 > n) {
            throw new IllegalArgumentException("standard length exceeded for value");
        }
        byte[] byArray2 = new byte[n];
        System.arraycopy(byArray, n2, byArray2, byArray2.length - n3, n3);
        return byArray2;
    }

    public static BigInteger fromUnsignedByteArray(byte[] byArray, int n, int n2) {
        byte[] byArray2 = byArray;
        if (n != 0 || n2 != byArray.length) {
            byArray2 = new byte[n2];
            System.arraycopy(byArray, n, byArray2, 0, n2);
        }
        return new BigInteger(1, byArray2);
    }

    public static BigInteger modOddInverse(BigInteger bigInteger, BigInteger bigInteger2) {
        int n;
        int[] nArray;
        int[] nArray2;
        int n2;
        int[] nArray3;
        if (!bigInteger.testBit(0)) {
            throw new IllegalArgumentException("'M' must be odd");
        }
        if (bigInteger.signum() != 1) {
            throw new ArithmeticException("BigInteger: modulus not positive");
        }
        if (bigInteger2.signum() < 0 || bigInteger2.compareTo(bigInteger) >= 0) {
            bigInteger2 = bigInteger2.mod(bigInteger);
        }
        if (0 == Mod.modOddInverse(nArray3 = Nat.fromBigInteger(n2 = bigInteger.bitLength(), bigInteger), nArray2 = Nat.fromBigInteger(n2, bigInteger2), nArray = Nat.create(n = nArray3.length))) {
            throw new ArithmeticException("BigInteger not invertible.");
        }
        return Nat.toBigInteger(n, nArray);
    }

    public static BigInteger createRandomBigInteger(int n, SecureRandom secureRandom) {
        return new BigInteger(1, BigIntegers.createRandom(n, secureRandom));
    }

    private static byte[] createRandom(int n, SecureRandom secureRandom) throws IllegalArgumentException {
        if (n < 1) {
            throw new IllegalArgumentException("bitLength must be at least 1");
        }
        int n2 = (n + 7) / 8;
        byte[] byArray = new byte[n2];
        secureRandom.nextBytes(byArray);
        int n3 = 8 * n2 - n;
        byArray[0] = (byte)(byArray[0] & (byte)(255 >>> n3));
        return byArray;
    }
}

