/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.math.ec;

import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.math.ec.AbstractECMultiplier;
import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.math.ec.ECCurve;
import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.math.ec.ECLookupTable;
import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.math.ec.ECPoint;
import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.math.ec.FixedPointPreCompInfo;
import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.math.ec.FixedPointUtil;
import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.math.raw.Nat;
import java.math.BigInteger;

public class FixedPointCombMultiplier
extends AbstractECMultiplier {
    protected ECPoint multiplyPositive(ECPoint eCPoint, BigInteger bigInteger) {
        ECCurve eCCurve = eCPoint.getCurve();
        int n = FixedPointUtil.getCombSize(eCCurve);
        if (bigInteger.bitLength() > n) {
            throw new IllegalStateException("fixed-point comb doesn't support scalars larger than the curve order");
        }
        FixedPointPreCompInfo fixedPointPreCompInfo = FixedPointUtil.precompute(eCPoint);
        ECLookupTable eCLookupTable = fixedPointPreCompInfo.getLookupTable();
        int n2 = fixedPointPreCompInfo.getWidth();
        int n3 = (n + n2 - 1) / n2;
        ECPoint eCPoint2 = eCCurve.getInfinity();
        int n4 = n3 * n2;
        int[] nArray = Nat.fromBigInteger(n4, bigInteger);
        int n5 = n4 - 1;
        for (int i = 0; i < n3; ++i) {
            int n6 = 0;
            for (int j = n5 - i; j >= 0; j -= n3) {
                int n7 = nArray[j >>> 5] >>> (j & 0x1F);
                n6 ^= n7 >>> 1;
                n6 <<= 1;
                n6 ^= n7;
            }
            ECPoint eCPoint3 = eCLookupTable.lookup(n6);
            eCPoint2 = eCPoint2.twicePlus(eCPoint3);
        }
        return eCPoint2.add(fixedPointPreCompInfo.getOffset());
    }
}

