/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.jcajce.provider.asymmetric.dsa;

import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.asn1.ASN1ObjectIdentifier;
import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.asn1.oiw.OIWObjectIdentifiers;
import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.crypto.params.DSAParameters;
import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.util.Arrays;
import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.util.Fingerprint;
import java.math.BigInteger;
import java.security.interfaces.DSAParams;

public class DSAUtil {
    public static final ASN1ObjectIdentifier[] dsaOids = new ASN1ObjectIdentifier[]{X9ObjectIdentifiers.id_dsa, OIWObjectIdentifiers.dsaWithSHA1, X9ObjectIdentifiers.id_dsa_with_sha1};

    public static boolean isDsaOid(ASN1ObjectIdentifier aSN1ObjectIdentifier) {
        for (int i = 0; i != dsaOids.length; ++i) {
            if (!aSN1ObjectIdentifier.equals(dsaOids[i])) continue;
            return true;
        }
        return false;
    }

    static DSAParameters toDSAParameters(DSAParams dSAParams) {
        if (dSAParams != null) {
            return new DSAParameters(dSAParams.getP(), dSAParams.getQ(), dSAParams.getG());
        }
        return null;
    }

    static String generateKeyFingerprint(BigInteger bigInteger, DSAParams dSAParams) {
        return new Fingerprint(Arrays.concatenate(bigInteger.toByteArray(), dSAParams.getP().toByteArray(), dSAParams.getQ().toByteArray(), dSAParams.getG().toByteArray())).toString();
    }
}

