/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.crypto.params;

import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.crypto.params.DHValidationParameters;
import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.util.Properties;
import java.math.BigInteger;

public class DHParameters {
    private BigInteger g;
    private BigInteger p;
    private BigInteger q;
    private BigInteger j;
    private int m;
    private int l;
    private DHValidationParameters validation;

    public DHParameters(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, int n, int n2, BigInteger bigInteger4, DHValidationParameters dHValidationParameters) {
        if (n2 != 0) {
            if (n2 > bigInteger.bitLength()) {
                throw new IllegalArgumentException("when l value specified, it must satisfy 2^(l-1) <= p");
            }
            if (n2 < n) {
                throw new IllegalArgumentException("when l value specified, it may not be less than m value");
            }
        }
        if (n > bigInteger.bitLength() && !Properties.isOverrideSet("io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.dh.allow_unsafe_p_value")) {
            throw new IllegalArgumentException("unsafe p value so small specific l required");
        }
        this.g = bigInteger2;
        this.p = bigInteger;
        this.q = bigInteger3;
        this.m = n;
        this.l = n2;
        this.j = bigInteger4;
        this.validation = dHValidationParameters;
    }

    public BigInteger getP() {
        return this.p;
    }

    public BigInteger getG() {
        return this.g;
    }

    public BigInteger getQ() {
        return this.q;
    }

    public boolean equals(Object object) {
        if (!(object instanceof DHParameters)) {
            return false;
        }
        DHParameters dHParameters = (DHParameters)object;
        if (this.getQ() != null ? !this.getQ().equals(dHParameters.getQ()) : dHParameters.getQ() != null) {
            return false;
        }
        return dHParameters.getP().equals(this.p) && dHParameters.getG().equals(this.g);
    }

    public int hashCode() {
        return this.getP().hashCode() ^ this.getG().hashCode() ^ (this.getQ() != null ? this.getQ().hashCode() : 0);
    }
}

