/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.cert;

import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.asn1.x500.X500Name;
import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.asn1.x509.Certificate;
import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.asn1.x509.Extensions;
import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.util.Encodable;
import java.io.IOException;
import java.io.Serializable;

public class X509CertificateHolder
implements Encodable,
Serializable {
    private transient Certificate x509Certificate;
    private transient Extensions extensions;

    public X509CertificateHolder(Certificate certificate) {
        this.init(certificate);
    }

    private void init(Certificate certificate) {
        this.x509Certificate = certificate;
        this.extensions = certificate.getTBSCertificate().getExtensions();
    }

    public X500Name getSubject() {
        return X500Name.getInstance(this.x509Certificate.getSubject());
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof X509CertificateHolder)) {
            return false;
        }
        X509CertificateHolder x509CertificateHolder = (X509CertificateHolder)object;
        return this.x509Certificate.equals(x509CertificateHolder.x509Certificate);
    }

    public int hashCode() {
        return this.x509Certificate.hashCode();
    }

    public byte[] getEncoded() throws IOException {
        return this.x509Certificate.getEncoded();
    }
}

