/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.asn1.sec;

import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.asn1.ASN1BitString;
import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.asn1.ASN1Encodable;
import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.asn1.ASN1EncodableVector;
import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.asn1.ASN1Integer;
import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.asn1.ASN1Object;
import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.asn1.ASN1OctetString;
import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.asn1.ASN1Primitive;
import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.asn1.ASN1Sequence;
import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.asn1.ASN1TaggedObject;
import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.asn1.DEROctetString;
import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.asn1.DERSequence;
import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.asn1.DERTaggedObject;
import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.util.BigIntegers;
import java.math.BigInteger;
import java.util.Enumeration;

public class ECPrivateKey
extends ASN1Object {
    private ASN1Sequence seq;

    private ECPrivateKey(ASN1Sequence aSN1Sequence) {
        this.seq = aSN1Sequence;
    }

    public static ECPrivateKey getInstance(Object object) {
        if (object instanceof ECPrivateKey) {
            return (ECPrivateKey)object;
        }
        if (object != null) {
            return new ECPrivateKey(ASN1Sequence.getInstance(object));
        }
        return null;
    }

    public ECPrivateKey(int n, BigInteger bigInteger, ASN1Encodable aSN1Encodable) {
        this(n, bigInteger, null, aSN1Encodable);
    }

    public ECPrivateKey(int n, BigInteger bigInteger, ASN1BitString aSN1BitString, ASN1Encodable aSN1Encodable) {
        byte[] byArray = BigIntegers.asUnsignedByteArray((n + 7) / 8, bigInteger);
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector(4);
        aSN1EncodableVector.add(new ASN1Integer(1L));
        aSN1EncodableVector.add(new DEROctetString(byArray));
        if (aSN1Encodable != null) {
            aSN1EncodableVector.add(new DERTaggedObject(true, 0, aSN1Encodable));
        }
        if (aSN1BitString != null) {
            aSN1EncodableVector.add(new DERTaggedObject(true, 1, aSN1BitString));
        }
        this.seq = new DERSequence(aSN1EncodableVector);
    }

    public BigInteger getKey() {
        ASN1OctetString aSN1OctetString = (ASN1OctetString)this.seq.getObjectAt(1);
        return new BigInteger(1, aSN1OctetString.getOctets());
    }

    public ASN1BitString getPublicKey() {
        return (ASN1BitString)this.getObjectInTag(1, 3);
    }

    public ASN1Object getParametersObject() {
        return this.getObjectInTag(0, -1);
    }

    private ASN1Object getObjectInTag(int n, int n2) {
        Enumeration enumeration = this.seq.getObjects();
        while (enumeration.hasMoreElements()) {
            ASN1TaggedObject aSN1TaggedObject;
            ASN1Encodable aSN1Encodable = (ASN1Encodable)enumeration.nextElement();
            if (!(aSN1Encodable instanceof ASN1TaggedObject) || !(aSN1TaggedObject = (ASN1TaggedObject)aSN1Encodable).hasContextTag(n)) continue;
            return n2 < 0 ? aSN1TaggedObject.getExplicitBaseObject().toASN1Primitive() : aSN1TaggedObject.getBaseUniversal(true, n2);
        }
        return null;
    }

    public ASN1Primitive toASN1Primitive() {
        return this.seq;
    }
}

