/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.internal.server.servlet;

import io.opentelemetry.testing.internal.armeria.common.annotation.Nullable;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.base.MoreObjects;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.collect.ImmutableList;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.io.BaseEncoding;
import io.opentelemetry.testing.internal.io.netty.util.internal.EmptyArrays;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.function.BiConsumer;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;

public final class ServletTlsAttributes {
    private static final String JAVAX_SERVLET_REQUEST_SSL_SESSION_ID = "javax.servlet.request.ssl_session_id";
    private static final String JAVAX_SERVLET_REQUEST_CIPHER_SUITE = "javax.servlet.request.cipher_suite";
    private static final String JAVAX_SERVLET_REQUEST_KEY_SIZE = "javax.servlet.request.key_size";
    private static final String JAVAX_SERVLET_REQUEST_X_509_CERTIFICATE = "javax.servlet.request.X509Certificate";
    private static final String ATTR_NAME = ServletTlsAttributes.class.getName();
    private static final String[] ALGORITHMS = new String[]{"_AES_256_", "_RC4_128_", "_AES_128_", "_CHACHA20_", "_ARIA256_", "_ARIA128_", "_CAMELLIA256_", "_CAMELLIA128_", "_RC4_40_", "_3DES_EDE_CBC_", "_IDEA_CBC_", "_RC2_CBC_40_", "_DES40_CBC_", "_DES_CBC_", "_SEED_"};
    private static final int[] KEY_SIZES = new int[]{256, 128, 128, 256, 256, 128, 256, 128, 40, 168, 128, 40, 40, 56, 128};
    private final String sessionId;
    private final String cipherSuite;
    private final int keySize;
    private final List<X509Certificate> peerCertificates;

    public static void fill(@Nullable SSLSession session, BiConsumer<String, Object> setter) {
        if (session == null) {
            return;
        }
        ServletTlsAttributes attrs = ServletTlsAttributes.getOrCreateAttrs(session);
        String sessionId = attrs.sessionId();
        String cipherSuite = attrs.cipherSuite();
        int keySize = attrs.keySize();
        List<X509Certificate> peerCerts = attrs.peerCertificates();
        setter.accept(JAVAX_SERVLET_REQUEST_SSL_SESSION_ID, sessionId);
        setter.accept(JAVAX_SERVLET_REQUEST_CIPHER_SUITE, cipherSuite);
        setter.accept(JAVAX_SERVLET_REQUEST_KEY_SIZE, keySize);
        if (!peerCerts.isEmpty()) {
            setter.accept(JAVAX_SERVLET_REQUEST_X_509_CERTIFICATE, peerCerts.toArray(EmptyArrays.EMPTY_X509_CERTIFICATES));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ServletTlsAttributes getOrCreateAttrs(SSLSession session) {
        ServletTlsAttributes attrs = (ServletTlsAttributes)session.getValue(ATTR_NAME);
        if (attrs != null) {
            return attrs;
        }
        SSLSession sSLSession = session;
        synchronized (sSLSession) {
            attrs = (ServletTlsAttributes)session.getValue(ATTR_NAME);
            if (attrs == null) {
                byte[] sessionIdBytes = session.getId();
                String sessionId = sessionIdBytes != null ? BaseEncoding.base16().encode(sessionIdBytes) : "";
                String cipherSuite = session.getCipherSuite();
                attrs = new ServletTlsAttributes(sessionId, MoreObjects.firstNonNull(cipherSuite, ""), ServletTlsAttributes.guessKeySize(cipherSuite), ServletTlsAttributes.getPeerX509Certificates(session));
                session.putValue(ATTR_NAME, attrs);
            }
            return attrs;
        }
    }

    static int guessKeySize(@Nullable String cipherSuite) {
        int startIdx;
        if (cipherSuite == null) {
            return 0;
        }
        int withIdx = cipherSuite.indexOf("_WITH_");
        if (withIdx > 0) {
            startIdx = withIdx + 5;
        } else {
            startIdx = cipherSuite.indexOf(95);
            if (startIdx < 0) {
                return 0;
            }
        }
        for (int i = 0; i < ALGORITHMS.length; ++i) {
            if (!cipherSuite.startsWith(ALGORITHMS[i], startIdx)) continue;
            return KEY_SIZES[i];
        }
        return 0;
    }

    private static List<X509Certificate> getPeerX509Certificates(SSLSession session) {
        try {
            Certificate[] certs = session.getPeerCertificates();
            if (certs == null) {
                return ImmutableList.of();
            }
            ImmutableList.Builder builder = ImmutableList.builderWithExpectedSize(certs.length);
            for (Certificate c : certs) {
                if (!(c instanceof X509Certificate)) continue;
                builder.add((X509Certificate)c);
            }
            return builder.build();
        }
        catch (SSLPeerUnverifiedException ignored) {
            return ImmutableList.of();
        }
    }

    private ServletTlsAttributes(String sessionId, String cipherSuite, int keySize, List<X509Certificate> peerCertificates) {
        this.sessionId = sessionId;
        this.cipherSuite = cipherSuite;
        this.keySize = keySize;
        this.peerCertificates = peerCertificates;
    }

    public String sessionId() {
        return this.sessionId;
    }

    public String cipherSuite() {
        return this.cipherSuite;
    }

    public int keySize() {
        return this.keySize;
    }

    public List<X509Certificate> peerCertificates() {
        return this.peerCertificates;
    }
}

