/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.internal.server.annotation;

import io.opentelemetry.testing.internal.armeria.common.AggregatedHttpRequest;
import io.opentelemetry.testing.internal.armeria.common.Cookie;
import io.opentelemetry.testing.internal.armeria.common.Cookies;
import io.opentelemetry.testing.internal.armeria.common.DependencyInjector;
import io.opentelemetry.testing.internal.armeria.common.HttpHeaderNames;
import io.opentelemetry.testing.internal.armeria.common.HttpHeaders;
import io.opentelemetry.testing.internal.armeria.common.HttpRequest;
import io.opentelemetry.testing.internal.armeria.common.MediaType;
import io.opentelemetry.testing.internal.armeria.common.QueryParamGetters;
import io.opentelemetry.testing.internal.armeria.common.QueryParams;
import io.opentelemetry.testing.internal.armeria.common.Request;
import io.opentelemetry.testing.internal.armeria.common.RequestContext;
import io.opentelemetry.testing.internal.armeria.common.RequestHeaders;
import io.opentelemetry.testing.internal.armeria.common.annotation.Nullable;
import io.opentelemetry.testing.internal.armeria.common.multipart.Multipart;
import io.opentelemetry.testing.internal.armeria.common.multipart.MultipartFile;
import io.opentelemetry.testing.internal.armeria.common.util.Exceptions;
import io.opentelemetry.testing.internal.armeria.internal.server.FileAggregatedMultipart;
import io.opentelemetry.testing.internal.armeria.internal.server.annotation.AnnotatedBeanFactory;
import io.opentelemetry.testing.internal.armeria.internal.server.annotation.AnnotatedBeanFactoryRegistry;
import io.opentelemetry.testing.internal.armeria.internal.server.annotation.AnnotatedElementNameUtil;
import io.opentelemetry.testing.internal.armeria.internal.server.annotation.AnnotatedObjectFactory;
import io.opentelemetry.testing.internal.armeria.internal.server.annotation.AnnotatedService;
import io.opentelemetry.testing.internal.armeria.internal.server.annotation.AnnotatedServiceFactory;
import io.opentelemetry.testing.internal.armeria.internal.server.annotation.AnnotatedServiceTypeUtil;
import io.opentelemetry.testing.internal.armeria.internal.server.annotation.AnnotationUtil;
import io.opentelemetry.testing.internal.armeria.internal.server.annotation.CompositeRequestConverterFunction;
import io.opentelemetry.testing.internal.armeria.internal.server.annotation.DefaultValues;
import io.opentelemetry.testing.internal.armeria.internal.server.annotation.KotlinUtil;
import io.opentelemetry.testing.internal.armeria.internal.server.annotation.ScalaUtil;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.base.Ascii;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.base.MoreObjects;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.base.Preconditions;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.base.Splitter;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.collect.ImmutableCollection;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.collect.ImmutableList;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.collect.ImmutableMap;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.collect.Iterables;
import io.opentelemetry.testing.internal.armeria.server.ServiceRequestContext;
import io.opentelemetry.testing.internal.armeria.server.annotation.ByteArrayRequestConverterFunction;
import io.opentelemetry.testing.internal.armeria.server.annotation.Default;
import io.opentelemetry.testing.internal.armeria.server.annotation.Delimiter;
import io.opentelemetry.testing.internal.armeria.server.annotation.FallthroughException;
import io.opentelemetry.testing.internal.armeria.server.annotation.Header;
import io.opentelemetry.testing.internal.armeria.server.annotation.JacksonRequestConverterFunction;
import io.opentelemetry.testing.internal.armeria.server.annotation.Param;
import io.opentelemetry.testing.internal.armeria.server.annotation.RequestConverter;
import io.opentelemetry.testing.internal.armeria.server.annotation.RequestConverterFunction;
import io.opentelemetry.testing.internal.armeria.server.annotation.RequestConverterFunctionProvider;
import io.opentelemetry.testing.internal.armeria.server.annotation.RequestObject;
import io.opentelemetry.testing.internal.armeria.server.annotation.StringRequestConverterFunction;
import io.opentelemetry.testing.internal.armeria.server.docs.DescriptionInfo;
import java.io.File;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.concurrent.ExecutionContext;

final class AnnotatedValueResolver {
    private static final Logger logger = LoggerFactory.getLogger(AnnotatedValueResolver.class);
    private static final List<RequestConverterFunction> defaultRequestConverterFunctions = ImmutableList.of(new JacksonRequestConverterFunction(), new StringRequestConverterFunction(), new ByteArrayRequestConverterFunction());
    private static final ClassValue<EnumConverter<?>> enumConverters = new ClassValue<EnumConverter<?>>(){

        @Override
        protected EnumConverter<?> computeValue(Class<?> type) {
            logger.debug("Registered an Enum {}", type);
            return new EnumConverter<Enum>(type.asSubclass(Enum.class));
        }
    };
    private static final Object[] emptyArguments = new Object[0];
    private static final List<RequestObjectResolver> defaultRequestObjectResolvers;
    static final List<RequestConverterFunctionProvider> requestConverterFunctionProviders;
    @Nullable
    private final Class<? extends Annotation> annotationType;
    private final String httpElementName;
    private final boolean isPathVariable;
    private final boolean shouldExist;
    private final boolean shouldWrapValueAsOptional;
    @Nullable
    private final Class<?> containerType;
    private final Class<?> elementType;
    @Nullable
    private final ParameterizedType parameterizedElementType;
    @Nullable
    private final Object defaultValue;
    private final DescriptionInfo description;
    private final BiFunction<AnnotatedValueResolver, ResolverContext, Object> resolver;
    @Nullable
    private final EnumConverter<?> enumConverter;
    @Nullable
    private final AnnotatedBeanFactoryRegistry.BeanFactoryId beanFactoryId;
    private final AggregationStrategy aggregationStrategy;

    static Object[] toArguments(List<AnnotatedValueResolver> resolvers, ResolverContext resolverContext) {
        Objects.requireNonNull(resolvers, "resolvers");
        Objects.requireNonNull(resolverContext, "resolverContext");
        if (resolvers.isEmpty()) {
            return emptyArguments;
        }
        return resolvers.stream().map(resolver -> resolver.resolve(resolverContext)).toArray();
    }

    static List<RequestObjectResolver> toRequestObjectResolvers(List<RequestConverterFunction> converters, Method method) {
        ImmutableList.Builder builder = ImmutableList.builder();
        converters.stream().map(RequestObjectResolver::of).forEach(builder::add);
        if (!requestConverterFunctionProviders.isEmpty()) {
            ImmutableCollection merged = ((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().addAll(converters)).addAll(defaultRequestConverterFunctions)).build();
            CompositeRequestConverterFunction composed = new CompositeRequestConverterFunction((ImmutableList<RequestConverterFunction>)merged);
            for (Type type : method.getGenericParameterTypes()) {
                for (RequestConverterFunctionProvider provider : requestConverterFunctionProviders) {
                    RequestConverterFunction func = provider.createRequestConverterFunction(type, composed);
                    if (func == null) continue;
                    builder.add(RequestObjectResolver.of(func));
                }
            }
        }
        builder.addAll(defaultRequestObjectResolvers);
        return builder.build();
    }

    static List<AnnotatedValueResolver> ofServiceMethod(Method method, Set<String> pathParams, List<RequestObjectResolver> objectResolvers, boolean useBlockingExecutor, DependencyInjector dependencyInjector, @Nullable String queryDelimiter) {
        return AnnotatedValueResolver.of(method, pathParams, objectResolvers, true, true, useBlockingExecutor, dependencyInjector, queryDelimiter);
    }

    static List<AnnotatedValueResolver> ofBeanConstructorOrMethod(Executable constructorOrMethod, Set<String> pathParams, List<RequestObjectResolver> objectResolvers, DependencyInjector dependencyInjector) {
        return AnnotatedValueResolver.of(constructorOrMethod, pathParams, objectResolvers, false, false, false, dependencyInjector, null);
    }

    @Nullable
    static AnnotatedValueResolver ofBeanField(Field field, Set<String> pathParams, List<RequestObjectResolver> objectResolvers, DependencyInjector dependencyInjector) {
        return AnnotatedValueResolver.of(field, field, field.getType(), pathParams, objectResolvers, false, false, dependencyInjector, null);
    }

    private static List<AnnotatedValueResolver> of(Executable constructorOrMethod, Set<String> pathParams, List<RequestObjectResolver> objectResolvers, boolean implicitRequestObjectAnnotation, boolean isServiceMethod, boolean useBlockingExecutor, DependencyInjector dependencyInjector, @Nullable String queryDelimiter) {
        AnnotatedValueResolver resolver;
        ImmutableList parameters = Arrays.stream(constructorOrMethod.getParameters()).filter(it -> !KotlinUtil.isContinuation(it.getType())).collect(ImmutableList.toImmutableList());
        int parametersSize = parameters.size();
        if (parametersSize == 0) {
            throw new NoParameterException(constructorOrMethod.toGenericString());
        }
        Parameter headParameter = (Parameter)parameters.get(0);
        if (AnnotatedValueResolver.isAnnotationPresent(constructorOrMethod)) {
            if (parametersSize != 1) {
                throw new IllegalArgumentException("Only one parameter is allowed to an annotated method: " + constructorOrMethod.toGenericString());
            }
            if (AnnotatedValueResolver.isAnnotationPresent(headParameter)) {
                throw new IllegalArgumentException("Both a method and parameter are annotated: " + constructorOrMethod.toGenericString());
            }
            resolver = AnnotatedValueResolver.of(constructorOrMethod, headParameter, headParameter.getType(), pathParams, objectResolvers, implicitRequestObjectAnnotation, useBlockingExecutor, dependencyInjector, queryDelimiter);
        } else if (!isServiceMethod && parametersSize == 1 && !AnnotationUtil.findDeclared(constructorOrMethod, RequestConverter.class).isEmpty()) {
            if (AnnotatedValueResolver.isAnnotationPresent(headParameter)) {
                throw new IllegalArgumentException("Both a method and parameter are annotated: " + constructorOrMethod.toGenericString());
            }
            resolver = AnnotatedValueResolver.of(headParameter, pathParams, objectResolvers, true, useBlockingExecutor, dependencyInjector, queryDelimiter);
        } else {
            if (constructorOrMethod.isAnnotationPresent(Default.class)) {
                throw new IllegalArgumentException('@' + Default.class.getSimpleName() + " is not supported for: " + constructorOrMethod.toGenericString());
            }
            resolver = null;
        }
        List<Object> list = resolver != null ? ImmutableList.of(resolver) : (List)parameters.stream().map(p -> AnnotatedValueResolver.of(p, pathParams, objectResolvers, implicitRequestObjectAnnotation, useBlockingExecutor, dependencyInjector, queryDelimiter)).filter(Objects::nonNull).collect(ImmutableList.toImmutableList());
        if (list.isEmpty()) {
            throw new NoAnnotatedParameterException(constructorOrMethod.toGenericString());
        }
        if (list.size() != parametersSize) {
            if (list.stream().anyMatch(r -> r.annotationType() != null)) {
                throw new IllegalArgumentException("Unsupported parameter exists: " + constructorOrMethod.toGenericString());
            }
            throw new NoAnnotatedParameterException("Unsupported parameter exists: " + constructorOrMethod.toGenericString());
        }
        AnnotatedValueResolver.warnOnDuplicateResolver(constructorOrMethod, list);
        return list;
    }

    @Nullable
    static AnnotatedValueResolver of(Parameter parameter, Set<String> pathParams, List<RequestObjectResolver> objectResolvers, boolean implicitRequestObjectAnnotation, boolean useBlockingExecutor, DependencyInjector dependencyInjector, @Nullable String queryDelimiter) {
        return AnnotatedValueResolver.of(parameter, parameter, parameter.getType(), pathParams, objectResolvers, implicitRequestObjectAnnotation, useBlockingExecutor, dependencyInjector, queryDelimiter);
    }

    @Nullable
    private static AnnotatedValueResolver of(AnnotatedElement annotatedElement, AnnotatedElement typeElement, Class<?> type, Set<String> pathParams, List<RequestObjectResolver> objectResolvers, boolean implicitRequestObjectAnnotation, boolean useBlockingExecutor, DependencyInjector dependencyInjector, @Nullable String queryDelimiter) {
        Objects.requireNonNull(annotatedElement, "annotatedElement");
        Objects.requireNonNull(typeElement, "typeElement");
        Objects.requireNonNull(type, "type");
        Objects.requireNonNull(pathParams, "pathParams");
        Objects.requireNonNull(objectResolvers, "objectResolvers");
        Objects.requireNonNull(dependencyInjector, "dependencyInjector");
        DescriptionInfo description = AnnotatedServiceFactory.findDescription(annotatedElement);
        Param param = annotatedElement.getAnnotation(Param.class);
        if (param != null) {
            String name = AnnotatedElementNameUtil.findName(param, (Object)typeElement);
            if (type == File.class || type == Path.class || type == MultipartFile.class) {
                return AnnotatedValueResolver.ofFileParam(name, annotatedElement, typeElement, type, description);
            }
            if (pathParams.contains(name)) {
                return AnnotatedValueResolver.ofPathVariable(name, annotatedElement, typeElement, type, description);
            }
            return AnnotatedValueResolver.ofQueryParam(name, annotatedElement, typeElement, type, description, queryDelimiter);
        }
        Header header = annotatedElement.getAnnotation(Header.class);
        if (header != null) {
            String name = AnnotatedElementNameUtil.findName(header, (Object)typeElement);
            return AnnotatedValueResolver.ofHeader(name, annotatedElement, typeElement, type, description);
        }
        String name = AnnotatedElementNameUtil.getNameOrDefault(typeElement, type.getName());
        RequestObject requestObject = annotatedElement.getAnnotation(RequestObject.class);
        if (requestObject != null) {
            List<RequestConverter> converters = AnnotationUtil.findDeclared(typeElement, RequestConverter.class);
            return AnnotatedValueResolver.ofRequestObject(name, annotatedElement, type, pathParams, AnnotatedValueResolver.addToFirstIfExists(objectResolvers, converters, dependencyInjector), dependencyInjector, description);
        }
        AnnotatedValueResolver resolver = AnnotatedValueResolver.ofInjectableTypes(name, typeElement, type, useBlockingExecutor);
        if (resolver != null) {
            return resolver;
        }
        List<RequestConverter> converters = AnnotationUtil.findDeclared(typeElement, RequestConverter.class);
        if (!converters.isEmpty()) {
            return AnnotatedValueResolver.ofRequestObject(name, annotatedElement, type, pathParams, AnnotatedValueResolver.addToFirstIfExists(objectResolvers, converters, dependencyInjector), dependencyInjector, description);
        }
        if (implicitRequestObjectAnnotation) {
            return AnnotatedValueResolver.ofRequestObject(name, annotatedElement, type, pathParams, objectResolvers, dependencyInjector, description);
        }
        return null;
    }

    static List<RequestObjectResolver> addToFirstIfExists(List<RequestObjectResolver> resolvers, List<RequestConverter> converters, DependencyInjector dependencyInjector) {
        if (converters.isEmpty()) {
            return resolvers;
        }
        ImmutableList.Builder builder = new ImmutableList.Builder();
        converters.forEach(c -> builder.add(RequestObjectResolver.of(AnnotatedObjectFactory.getInstance(c, RequestConverterFunction.class, dependencyInjector))));
        builder.addAll(resolvers);
        return builder.build();
    }

    private static boolean isAnnotationPresent(AnnotatedElement element) {
        return element.isAnnotationPresent(Param.class) || element.isAnnotationPresent(Header.class) || element.isAnnotationPresent(RequestObject.class);
    }

    private static void warnOnDuplicateResolver(Executable constructorOrMethod, List<AnnotatedValueResolver> list) {
        Set<AnnotatedValueResolver> uniques = AnnotatedBeanFactoryRegistry.uniqueResolverSet();
        list.forEach(element -> {
            if (!uniques.add((AnnotatedValueResolver)element)) {
                AnnotatedBeanFactoryRegistry.warnDuplicateResolver(element, constructorOrMethod.toGenericString());
            }
        });
    }

    private static AnnotatedValueResolver ofPathVariable(String name, AnnotatedElement annotatedElement, AnnotatedElement typeElement, Class<?> type, DescriptionInfo description) {
        return new Builder(annotatedElement, type, name).annotationType(Param.class).typeElement(typeElement).pathVariable(true).description(description).resolver(AnnotatedValueResolver.resolver(ctx -> ctx.context().pathParam(name))).build();
    }

    private static AnnotatedValueResolver ofQueryParam(String name, AnnotatedElement annotatedElement, AnnotatedElement typeElement, Class<?> type, DescriptionInfo description, @Nullable String serviceQueryDelimiter) {
        String queryDelimiter = serviceQueryDelimiter;
        Delimiter delimiter = annotatedElement.getAnnotation(Delimiter.class);
        if (delimiter != null && DefaultValues.isSpecified(delimiter.value())) {
            queryDelimiter = delimiter.value();
        }
        return new Builder(annotatedElement, type, name).annotationType(Param.class).typeElement(typeElement).supportDefault(true).supportContainer(true).description(description).aggregation(AggregationStrategy.FOR_FORM_DATA).resolver(AnnotatedValueResolver.resolver(ctx -> ctx.queryParams().getAll(name), () -> "Cannot resolve a value from a query parameter: " + name, queryDelimiter)).build();
    }

    private static AnnotatedValueResolver ofFileParam(String name, AnnotatedElement annotatedElement, AnnotatedElement typeElement, Class<?> type, DescriptionInfo description) {
        return new Builder(annotatedElement, type, name).annotationType(Param.class).typeElement(typeElement).supportContainer(true).description(description).aggregation(AggregationStrategy.ALWAYS).resolver(AnnotatedValueResolver.fileResolver()).build();
    }

    private static AnnotatedValueResolver ofHeader(String name, AnnotatedElement annotatedElement, AnnotatedElement typeElement, Class<?> type, DescriptionInfo description) {
        return new Builder(annotatedElement, type, name).annotationType(Header.class).typeElement(typeElement).supportDefault(true).supportContainer(true).description(description).resolver(AnnotatedValueResolver.resolver(ctx -> ctx.request().headers().getAll(HttpHeaderNames.of(name)), () -> "Cannot resolve a value from HTTP header: " + name, null)).build();
    }

    private static AnnotatedValueResolver ofRequestObject(String name, AnnotatedElement annotatedElement, Class<?> type, Set<String> pathParams, List<RequestObjectResolver> objectResolvers, DependencyInjector dependencyInjector, DescriptionInfo description) {
        AnnotatedBeanFactoryRegistry.BeanFactoryId beanFactoryId = AnnotatedBeanFactoryRegistry.register(type, pathParams, objectResolvers, dependencyInjector);
        return new Builder(annotatedElement, type, name).annotationType(RequestObject.class).description(description).aggregation(AggregationStrategy.ALWAYS).resolver(AnnotatedValueResolver.resolver(objectResolvers, beanFactoryId)).beanFactoryId(beanFactoryId).build();
    }

    @Nullable
    private static AnnotatedValueResolver ofInjectableTypes(String name, AnnotatedElement annotatedElement, Class<?> type, boolean useBlockingExecutor) {
        if (type != Optional.class) {
            return AnnotatedValueResolver.ofInjectableTypes0(name, annotatedElement, type, type, useBlockingExecutor);
        }
        Type actual = ((ParameterizedType)AnnotatedValueResolver.parameterizedTypeOf(annotatedElement)).getActualTypeArguments()[0];
        AnnotatedValueResolver resolver = AnnotatedValueResolver.ofInjectableTypes0(name, annotatedElement, type, actual, useBlockingExecutor);
        if (resolver != null) {
            logger.warn("Unnecessary Optional is used at '{}'", (Object)annotatedElement);
        }
        return resolver;
    }

    @Nullable
    private static AnnotatedValueResolver ofInjectableTypes0(String name, AnnotatedElement annotatedElement, Class<?> type, Type actual, boolean useBlockingExecutor) {
        if (actual == RequestContext.class || actual == ServiceRequestContext.class) {
            return new Builder(annotatedElement, type, name).resolver((unused, ctx) -> ctx.context()).build();
        }
        if (actual == Request.class || actual == HttpRequest.class) {
            return new Builder(annotatedElement, type, name).resolver((unused, ctx) -> ctx.request()).build();
        }
        if (actual == HttpHeaders.class || actual == RequestHeaders.class) {
            return new Builder(annotatedElement, type, name).resolver((unused, ctx) -> ctx.request().headers()).build();
        }
        if (actual == AggregatedHttpRequest.class) {
            return new Builder(annotatedElement, type, name).resolver((unused, ctx) -> ctx.aggregatedRequest()).aggregation(AggregationStrategy.ALWAYS).build();
        }
        if (actual == QueryParams.class) {
            return new Builder(annotatedElement, type, name).resolver((unused, ctx) -> ctx.queryParams()).aggregation(AggregationStrategy.FOR_FORM_DATA).build();
        }
        if (actual == Multipart.class) {
            return new Builder(annotatedElement, type, name).resolver((unused, ctx) -> Multipart.from(ctx.request())).build();
        }
        if (actual == MultipartFile.class) {
            return new Builder(annotatedElement, type, name).resolver((unused, ctx) -> {
                String filename = AnnotatedElementNameUtil.getName(annotatedElement);
                return Iterables.getFirst(ctx.aggregatedMultipart().files().get((Object)filename), null);
            }).aggregation(AggregationStrategy.ALWAYS).build();
        }
        if (actual == Cookies.class) {
            return new Builder(annotatedElement, type, name).resolver((unused, ctx) -> {
                String value = ctx.request().headers().get(HttpHeaderNames.COOKIE);
                if (value == null) {
                    return Cookies.of();
                }
                return Cookie.fromCookieHeader(value);
            }).build();
        }
        if (actual instanceof Class && ScalaUtil.isExecutionContext((Class)actual)) {
            return new Builder(annotatedElement, type, name).resolver((unused, ctx) -> {
                if (useBlockingExecutor) {
                    return ExecutionContext.fromExecutorService((ExecutorService)ctx.context().blockingTaskExecutor());
                }
                return ExecutionContext.fromExecutorService((ExecutorService)ctx.context().eventLoop());
            }).build();
        }
        return null;
    }

    private static BiFunction<AnnotatedValueResolver, ResolverContext, Object> resolver(Function<ResolverContext, String> getter) {
        return (resolver, ctx) -> resolver.convert((String)getter.apply((ResolverContext)ctx));
    }

    private static BiFunction<AnnotatedValueResolver, ResolverContext, Object> resolver(Function<ResolverContext, List<String>> getter, Supplier<String> failureMessageSupplier, @Nullable String queryDelimiter) {
        return (resolver, ctx) -> {
            List values = (List)getter.apply((ResolverContext)ctx);
            if (!resolver.hasContainer()) {
                if (values != null && !values.isEmpty()) {
                    return resolver.convert((String)values.get(0));
                }
                return resolver.defaultOrException();
            }
            try {
                assert (resolver.containerType() != null);
                Collection resolvedValues = (Collection)resolver.containerType().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                if (values != null && !values.isEmpty()) {
                    if (queryDelimiter != null && values.size() == 1) {
                        String first = (String)values.get(0);
                        Splitter.on(queryDelimiter).splitToStream(first).map(resolver::convert).forEach(resolvedValues::add);
                    } else {
                        values.stream().map(resolver::convert).forEach(resolvedValues::add);
                    }
                } else {
                    Object defaultValue = resolver.defaultOrException();
                    if (defaultValue != null) {
                        resolvedValues.add(defaultValue);
                    }
                }
                return resolvedValues;
            }
            catch (Throwable cause) {
                throw new IllegalArgumentException((String)failureMessageSupplier.get(), cause);
            }
        };
    }

    private static BiFunction<AnnotatedValueResolver, ResolverContext, Object> resolver(List<RequestObjectResolver> objectResolvers, AnnotatedBeanFactoryRegistry.BeanFactoryId beanFactoryId) {
        return (resolver, ctx) -> {
            boolean found = false;
            Object value = null;
            for (RequestObjectResolver objectResolver : objectResolvers) {
                try {
                    value = objectResolver.convert((ResolverContext)ctx, resolver.elementType(), resolver.parameterizedElementType(), beanFactoryId);
                    found = true;
                    break;
                }
                catch (FallthroughException fallthroughException) {
                }
                catch (Throwable cause) {
                    Exceptions.throwUnsafely(cause);
                }
            }
            if (!found) {
                throw new IllegalArgumentException("No suitable request converter found for a @" + RequestObject.class.getSimpleName() + " '" + resolver.elementType().getSimpleName() + '\'');
            }
            if (value == null && resolver.shouldExist()) {
                throw new IllegalArgumentException("A request converter converted the request into null, but the injection target is neither an Optional nor annotated with @Nullable");
            }
            return value;
        };
    }

    private static BiFunction<AnnotatedValueResolver, ResolverContext, Object> fileResolver() {
        return (resolver, ctx) -> {
            Function<MultipartFile, Object> mapper;
            FileAggregatedMultipart fileAggregatedMultipart = ctx.aggregatedMultipart();
            if (fileAggregatedMultipart == null) {
                return resolver.defaultOrException();
            }
            Class<?> elementType = resolver.elementType();
            if (elementType == File.class) {
                mapper = MultipartFile::file;
            } else if (elementType == MultipartFile.class) {
                mapper = Function.identity();
            } else {
                assert (elementType == Path.class);
                mapper = multipartFile -> multipartFile.file().toPath();
            }
            String name = resolver.httpElementName();
            Collection values = fileAggregatedMultipart.files().get((Object)name);
            if (!resolver.hasContainer()) {
                if (values != null && !values.isEmpty()) {
                    return mapper.apply((MultipartFile)values.get(0));
                }
                return resolver.defaultOrException();
            }
            try {
                assert (resolver.containerType() != null);
                Collection resolvedValues = (Collection)resolver.containerType().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                if (values != null && !values.isEmpty()) {
                    values.stream().map(mapper::apply).forEach(resolvedValues::add);
                } else {
                    Object defaultValue = resolver.defaultOrException();
                    if (defaultValue != null) {
                        resolvedValues.add(defaultValue);
                    }
                }
                return resolvedValues;
            }
            catch (Throwable cause) {
                throw new IllegalArgumentException("Cannot resolve a file param: " + name, cause);
            }
        };
    }

    private static Type parameterizedTypeOf(AnnotatedElement element) {
        if (element instanceof Parameter) {
            return ((Parameter)element).getParameterizedType();
        }
        if (element instanceof Field) {
            return ((Field)element).getGenericType();
        }
        throw new IllegalArgumentException("Unsupported annotated element: " + element.getClass().getSimpleName());
    }

    static boolean isAnnotatedNullable(AnnotatedElement annotatedElement) {
        for (Annotation a : annotatedElement.getAnnotations()) {
            String annotationTypeName = a.annotationType().getName();
            if (!annotationTypeName.endsWith(".Nullable")) continue;
            return true;
        }
        return false;
    }

    private AnnotatedValueResolver(@Nullable Class<? extends Annotation> annotationType, String httpElementName, boolean isPathVariable, boolean shouldExist, boolean shouldWrapValueAsOptional, @Nullable Class<?> containerType, Class<?> elementType, @Nullable ParameterizedType parameterizedElementType, @Nullable String defaultValue, DescriptionInfo description, BiFunction<AnnotatedValueResolver, ResolverContext, Object> resolver, @Nullable AnnotatedBeanFactoryRegistry.BeanFactoryId beanFactoryId, AggregationStrategy aggregationStrategy) {
        this.annotationType = annotationType;
        this.httpElementName = httpElementName;
        this.isPathVariable = isPathVariable;
        this.shouldExist = shouldExist;
        this.shouldWrapValueAsOptional = shouldWrapValueAsOptional;
        this.elementType = Objects.requireNonNull(elementType, "elementType");
        this.parameterizedElementType = parameterizedElementType;
        this.description = Objects.requireNonNull(description, "description");
        this.containerType = containerType;
        this.resolver = Objects.requireNonNull(resolver, "resolver");
        this.beanFactoryId = beanFactoryId;
        this.aggregationStrategy = Objects.requireNonNull(aggregationStrategy, "aggregationStrategy");
        this.enumConverter = AnnotatedValueResolver.enumConverter(elementType);
        this.defaultValue = defaultValue != null ? AnnotatedValueResolver.convert(defaultValue, elementType, this.enumConverter) : null;
    }

    @Nullable
    private static EnumConverter<?> enumConverter(Class<?> elementType) {
        if (!elementType.isEnum()) {
            return null;
        }
        return enumConverters.get(elementType);
    }

    @Nullable
    Class<? extends Annotation> annotationType() {
        return this.annotationType;
    }

    String httpElementName() {
        return this.httpElementName;
    }

    boolean isPathVariable() {
        return this.isPathVariable;
    }

    boolean shouldExist() {
        return this.shouldExist;
    }

    boolean shouldWrapValueAsOptional() {
        return this.shouldWrapValueAsOptional;
    }

    @Nullable
    Class<?> containerType() {
        return this.containerType;
    }

    Class<?> elementType() {
        return this.elementType;
    }

    @Nullable
    ParameterizedType parameterizedElementType() {
        return this.parameterizedElementType;
    }

    @Nullable
    Object defaultValue() {
        return this.defaultValue;
    }

    DescriptionInfo description() {
        return this.description;
    }

    @Nullable
    AnnotatedBeanFactoryRegistry.BeanFactoryId beanFactoryId() {
        return this.beanFactoryId;
    }

    AggregationStrategy aggregationStrategy() {
        return this.aggregationStrategy;
    }

    boolean hasContainer() {
        return this.containerType != null && (List.class.isAssignableFrom(this.containerType) || Set.class.isAssignableFrom(this.containerType));
    }

    Object resolve(ResolverContext ctx) {
        Optional<Object> resolved = this.resolver.apply(this, ctx);
        return this.shouldWrapValueAsOptional ? Optional.ofNullable(resolved) : resolved;
    }

    private static Object convert(String value, Class<?> elementType, @Nullable EnumConverter<?> enumConverter) {
        return enumConverter != null ? enumConverter.toEnum(value) : AnnotatedServiceTypeUtil.stringToType(value, elementType);
    }

    @Nullable
    private Object convert(@Nullable String value) {
        if (value == null) {
            return this.defaultOrException();
        }
        return AnnotatedValueResolver.convert(value, this.elementType, this.enumConverter);
    }

    @Nullable
    private Object defaultOrException() {
        if (!this.shouldExist) {
            return this.defaultValue;
        }
        throw new IllegalArgumentException("Mandatory parameter/header is missing: " + this.httpElementName);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).omitNullValues().add("annotation", this.annotationType != null ? this.annotationType.getSimpleName() : "(none)").add("httpElementName", this.httpElementName).add("pathVariable", this.isPathVariable).add("shouldExist", this.shouldExist).add("shouldWrapValueAsOptional", this.shouldWrapValueAsOptional).add("elementType", this.elementType.getSimpleName()).add("containerType", this.containerType != null ? this.containerType.getSimpleName() : "(none)").add("defaultValue", this.defaultValue).add("defaultValueType", this.defaultValue != null ? this.defaultValue.getClass().getSimpleName() : "(none)").add("description", this.description).add("resolver", this.resolver).add("enumConverter", this.enumConverter).toString();
    }

    private static boolean isFormData(@Nullable MediaType contentType) {
        return contentType != null && contentType.belongsTo(MediaType.FORM_DATA);
    }

    private static boolean isMultipartFormData(@Nullable MediaType contentType) {
        return contentType != null && contentType.belongsTo(MediaType.MULTIPART_FORM_DATA);
    }

    static AggregationType aggregationType(AggregationStrategy strategy, RequestHeaders headers) {
        Objects.requireNonNull(strategy, "strategy");
        MediaType mediaType = headers.contentType();
        if (AnnotatedValueResolver.isMultipartFormData(mediaType)) {
            if (strategy == AggregationStrategy.NONE) {
                return AggregationType.NONE;
            }
            return AggregationType.MULTIPART;
        }
        switch (strategy) {
            case ALWAYS: {
                return AggregationType.ALL;
            }
            case FOR_FORM_DATA: {
                return AnnotatedValueResolver.isFormData(mediaType) ? AggregationType.ALL : AggregationType.NONE;
            }
        }
        return AggregationType.NONE;
    }

    static {
        ImmutableList.Builder builder = ImmutableList.builderWithExpectedSize(4);
        builder.add((resolverContext, expectedResultType, expectedParameterizedResultType, beanFactoryId) -> {
            AnnotatedBeanFactory<?> factory = AnnotatedBeanFactoryRegistry.find(beanFactoryId);
            if (factory == null) {
                return RequestConverterFunction.fallthrough();
            }
            return factory.create(resolverContext);
        });
        for (RequestConverterFunction function : defaultRequestConverterFunctions) {
            builder.add(RequestObjectResolver.of(function));
        }
        defaultRequestObjectResolvers = builder.build();
        requestConverterFunctionProviders = ImmutableList.copyOf(ServiceLoader.load(RequestConverterFunctionProvider.class, AnnotatedService.class.getClassLoader()));
        if (!requestConverterFunctionProviders.isEmpty()) {
            logger.debug("Available {}s: {}", (Object)RequestConverterFunctionProvider.class.getSimpleName(), requestConverterFunctionProviders);
        }
    }

    static enum AggregationStrategy {
        NONE,
        ALWAYS,
        FOR_FORM_DATA;


        static AggregationStrategy from(List<AnnotatedValueResolver> resolvers) {
            AggregationStrategy strategy = NONE;
            for (AnnotatedValueResolver r : resolvers) {
                switch (r.aggregationStrategy()) {
                    case ALWAYS: {
                        return ALWAYS;
                    }
                    case FOR_FORM_DATA: {
                        strategy = FOR_FORM_DATA;
                    }
                }
            }
            return strategy;
        }
    }

    static class ResolverContext {
        private final ServiceRequestContext context;
        private final HttpRequest request;
        @Nullable
        private final AggregatedResult aggregatedResult;
        private volatile QueryParams queryParams;

        ResolverContext(ServiceRequestContext context, HttpRequest request, AggregatedResult aggregatedResult) {
            this.context = Objects.requireNonNull(context, "context");
            this.request = Objects.requireNonNull(request, "request");
            this.aggregatedResult = Objects.requireNonNull(aggregatedResult, "aggregatedResult");
        }

        ServiceRequestContext context() {
            return this.context;
        }

        HttpRequest request() {
            return this.request;
        }

        @Nullable
        AggregatedHttpRequest aggregatedRequest() {
            return this.aggregatedResult.aggregatedHttpRequest;
        }

        @Nullable
        FileAggregatedMultipart aggregatedMultipart() {
            return this.aggregatedResult.aggregatedMultipart;
        }

        QueryParams queryParams() {
            QueryParams result = this.queryParams;
            if (result == null && (result = this.queryParams) == null) {
                this.queryParams = result = ResolverContext.queryParamsOf(this.context.query(), this.request.contentType(), this.aggregatedResult);
            }
            return result;
        }

        public String toString() {
            return MoreObjects.toStringHelper(this).omitNullValues().add("context", this.context).add("request", this.request).add("aggregatedResult", this.aggregatedResult).add("queryParams", this.queryParams).toString();
        }

        private static QueryParams queryParamsOf(@Nullable String query, @Nullable MediaType contentType, AggregatedResult result) {
            try {
                FileAggregatedMultipart multipart;
                QueryParams params1 = query != null ? QueryParams.fromQueryString(query) : null;
                QueryParamGetters params2 = null;
                if (AnnotatedValueResolver.isFormData(contentType)) {
                    String body;
                    AggregatedHttpRequest message = result.aggregatedHttpRequest;
                    if (message != null && !(body = message.content(contentType.charset(StandardCharsets.US_ASCII))).isEmpty()) {
                        params2 = QueryParams.fromQueryString(body);
                    }
                } else if (AnnotatedValueResolver.isMultipartFormData(contentType) && (multipart = result.aggregatedMultipart) != null) {
                    params2 = QueryParams.builder().add(multipart.params().entries()).build();
                }
                if (params1 == null || params1.isEmpty()) {
                    return MoreObjects.firstNonNull(params2, QueryParams.of());
                }
                if (params2 == null || params2.isEmpty()) {
                    return params1;
                }
                return QueryParams.builder().sizeHint(params1.size() + params2.size()).add(params1).add(params2).build();
            }
            catch (Exception e) {
                logger.debug("Failed to decode query string: {}", (Object)query, (Object)e);
                return QueryParams.of();
            }
        }
    }

    @FunctionalInterface
    static interface RequestObjectResolver {
        public static RequestObjectResolver of(RequestConverterFunction function) {
            return (resolverContext, expectedResultType, expectedParameterizedResultType, beanFactoryId) -> {
                AggregatedHttpRequest request = resolverContext.aggregatedRequest();
                if (request == null) {
                    throw new IllegalArgumentException("Cannot convert this request to an object because it is not aggregated.");
                }
                return function.convertRequest(resolverContext.context(), request, expectedResultType, expectedParameterizedResultType);
            };
        }

        @Nullable
        public Object convert(ResolverContext var1, Class<?> var2, @Nullable ParameterizedType var3, @Nullable AnnotatedBeanFactoryRegistry.BeanFactoryId var4) throws Throwable;
    }

    static class NoParameterException
    extends NoAnnotatedParameterException {
        private static final long serialVersionUID = 3390292442571367102L;

        NoParameterException(String name) {
            super("No parameters found from: " + name);
        }
    }

    static class NoAnnotatedParameterException
    extends IllegalArgumentException {
        private static final long serialVersionUID = -6003890710456747277L;

        NoAnnotatedParameterException(String name) {
            super("No annotated parameters found from: " + name);
        }
    }

    private static final class Builder {
        private final AnnotatedElement annotatedElement;
        private final Type type;
        private final String httpElementName;
        private AnnotatedElement typeElement;
        @Nullable
        private Class<? extends Annotation> annotationType;
        private boolean pathVariable;
        private boolean supportContainer;
        private boolean supportDefault;
        private DescriptionInfo description = DescriptionInfo.empty();
        @Nullable
        private BiFunction<AnnotatedValueResolver, ResolverContext, Object> resolver;
        @Nullable
        private AnnotatedBeanFactoryRegistry.BeanFactoryId beanFactoryId;
        private AggregationStrategy aggregation = AggregationStrategy.NONE;
        private boolean warnedRedundantUse;

        private Builder(AnnotatedElement annotatedElement, Type type, String name) {
            this.annotatedElement = Objects.requireNonNull(annotatedElement, "annotatedElement");
            this.type = Objects.requireNonNull(type, "type");
            this.httpElementName = Objects.requireNonNull(name, "name");
            this.typeElement = annotatedElement;
        }

        private Builder annotationType(Class<? extends Annotation> annotationType) {
            assert (annotationType == Param.class || annotationType == Header.class || annotationType == RequestObject.class) : annotationType.getSimpleName();
            this.annotationType = annotationType;
            return this;
        }

        private Builder pathVariable(boolean pathVariable) {
            this.pathVariable = pathVariable;
            return this;
        }

        private Builder supportContainer(boolean supportContainer) {
            this.supportContainer = supportContainer;
            return this;
        }

        private Builder supportDefault(boolean supportDefault) {
            this.supportDefault = supportDefault;
            return this;
        }

        private Builder typeElement(AnnotatedElement typeElement) {
            this.typeElement = typeElement;
            return this;
        }

        private Builder description(DescriptionInfo description) {
            this.description = description;
            return this;
        }

        private Builder resolver(BiFunction<AnnotatedValueResolver, ResolverContext, Object> resolver) {
            this.resolver = resolver;
            return this;
        }

        private Builder beanFactoryId(AnnotatedBeanFactoryRegistry.BeanFactoryId beanFactoryId) {
            this.beanFactoryId = beanFactoryId;
            return this;
        }

        private Builder aggregation(AggregationStrategy aggregation) {
            this.aggregation = aggregation;
            return this;
        }

        private AnnotatedValueResolver build() {
            ParameterizedType parameterizedElementType;
            Class elementType;
            Class<?> containerType;
            String defaultValue;
            boolean shouldExist;
            Default aDefault;
            String nullableRepresentation;
            Preconditions.checkArgument(this.resolver != null, "'resolver' should be specified");
            boolean isOptional = this.type == Optional.class;
            boolean isAnnotatedNullable = AnnotatedValueResolver.isAnnotatedNullable(this.typeElement);
            boolean isMarkedNullable = KotlinUtil.isMarkedNullable(this.typeElement);
            boolean isNullable = isAnnotatedNullable || isMarkedNullable;
            Type originalParameterizedType = AnnotatedValueResolver.parameterizedTypeOf(this.typeElement);
            Type unwrappedParameterizedType = isOptional ? Builder.unwrapOptional(originalParameterizedType) : originalParameterizedType;
            String string = nullableRepresentation = isMarkedNullable && !isAnnotatedNullable ? "?(Kotlin nullable type)" : "@Nullable";
            if (isAnnotatedNullable && isMarkedNullable) {
                this.warnRedundantUse("@Nullable", "?(Kotlin nullable type)");
            }
            if (isOptional && isNullable) {
                this.warnRedundantUse("Optional", nullableRepresentation);
            }
            if ((aDefault = this.annotatedElement.getAnnotation(Default.class)) != null) {
                if (this.supportDefault) {
                    if (isOptional) {
                        this.warnRedundantUse("@Default", "Optional");
                    } else if (isNullable) {
                        this.warnRedundantUse("@Default", nullableRepresentation);
                    }
                    shouldExist = false;
                    defaultValue = DefaultValues.getSpecifiedValue(aDefault.value());
                } else {
                    this.warnRedundantUse("@Default", null);
                    shouldExist = !isOptional;
                    defaultValue = null;
                }
            } else {
                defaultValue = null;
                if (isOptional) {
                    shouldExist = false;
                } else {
                    boolean bl = shouldExist = !isNullable;
                }
            }
            if (this.pathVariable && !shouldExist) {
                if (isOptional) {
                    this.warnRedundantUse("a path variable", "Optional");
                } else {
                    this.warnRedundantUse("a path variable", nullableRepresentation);
                }
            }
            if ((containerType = this.getContainerType(unwrappedParameterizedType)) != null) {
                elementType = this.getElementType(unwrappedParameterizedType, isOptional);
                parameterizedElementType = Builder.getParameterizedElementType(unwrappedParameterizedType);
            } else if (unwrappedParameterizedType instanceof Class) {
                elementType = (Class)unwrappedParameterizedType;
                parameterizedElementType = null;
            } else if (unwrappedParameterizedType instanceof ParameterizedType) {
                parameterizedElementType = (ParameterizedType)unwrappedParameterizedType;
                elementType = (Class)parameterizedElementType.getRawType();
            } else {
                throw new IllegalArgumentException("Unsupported parameter type: " + unwrappedParameterizedType.getTypeName());
            }
            return new AnnotatedValueResolver(this.annotationType, this.httpElementName, this.pathVariable, shouldExist, isOptional, containerType, elementType, parameterizedElementType, defaultValue, this.description, this.resolver, this.beanFactoryId, this.aggregation);
        }

        private void warnRedundantUse(String whatWasUsed1, @Nullable String whatWasUsed2) {
            if (this.warnedRedundantUse) {
                return;
            }
            this.warnedRedundantUse = true;
            StringBuilder buf = new StringBuilder();
            buf.append("Found a redundant ");
            if (whatWasUsed2 != null) {
                buf.append("combined ");
            }
            buf.append("use of ").append(whatWasUsed1);
            if (whatWasUsed2 != null) {
                buf.append(" and ").append(whatWasUsed2);
            }
            buf.append(" in '").append(this.typeElement).append('\'');
            if (this.typeElement != this.annotatedElement) {
                buf.append(" of '").append(this.annotatedElement).append('\'');
            }
            if (this.annotationType != null) {
                buf.append(" (type: ").append(this.annotationType.getSimpleName()).append(')');
            }
            logger.warn(buf.toString());
        }

        @Nullable
        private Class<?> getContainerType(Type parameterizedType) {
            Class<?> rawType = Builder.toRawType(parameterizedType);
            if (this.pathVariable && Iterable.class.isAssignableFrom(rawType)) {
                throw new IllegalArgumentException("Container type is not supported for a path variable: " + this.httpElementName + " (" + parameterizedType + ')');
            }
            if (!this.supportContainer) {
                return null;
            }
            if (rawType == Iterable.class || rawType == List.class || rawType == Collection.class) {
                return ArrayList.class;
            }
            if (rawType == Set.class) {
                return LinkedHashSet.class;
            }
            if (List.class.isAssignableFrom(rawType) || Set.class.isAssignableFrom(rawType)) {
                try {
                    Objects.requireNonNull(rawType.getConstructor(new Class[0]));
                    return rawType;
                }
                catch (Throwable cause) {
                    throw new IllegalArgumentException("Unsupported container type: " + rawType.getName(), cause);
                }
            }
            return null;
        }

        private Class<?> getElementType(Type parameterizedType, boolean unwrapOptional) {
            Type elementType;
            if (!(parameterizedType instanceof ParameterizedType)) {
                return Builder.toRawType(unwrapOptional ? parameterizedType : this.type);
            }
            try {
                elementType = ((ParameterizedType)parameterizedType).getActualTypeArguments()[0];
            }
            catch (Throwable cause) {
                throw new IllegalArgumentException("Unsupported or invalid parameter type: " + parameterizedType, cause);
            }
            return Builder.toRawType(elementType);
        }

        @Nullable
        private static ParameterizedType getParameterizedElementType(Type parameterizedType) {
            if (!(parameterizedType instanceof ParameterizedType)) {
                return null;
            }
            try {
                Type elementType = ((ParameterizedType)parameterizedType).getActualTypeArguments()[0];
                if (elementType instanceof ParameterizedType) {
                    return (ParameterizedType)elementType;
                }
            }
            catch (Throwable cause) {
                throw new IllegalArgumentException("Unsupported parameter type: " + parameterizedType, cause);
            }
            return null;
        }

        private static Type unwrapOptional(Type parameterizedType) {
            assert (parameterizedType instanceof ParameterizedType) : String.valueOf(parameterizedType);
            parameterizedType = ((ParameterizedType)parameterizedType).getActualTypeArguments()[0];
            return parameterizedType;
        }

        private static Class<?> toRawType(Type type) {
            Type[] bounds;
            Type[] upperBounds;
            if (type instanceof Class) {
                return (Class)type;
            }
            if (type instanceof ParameterizedType) {
                return (Class)((ParameterizedType)type).getRawType();
            }
            if (type instanceof WildcardType && (upperBounds = ((WildcardType)type).getUpperBounds()).length > 0) {
                return (Class)upperBounds[0];
            }
            if (type instanceof TypeVariable && (bounds = ((TypeVariable)type).getBounds()).length > 0) {
                return (Class)bounds[0];
            }
            throw new IllegalArgumentException("Unsupported or invalid parameter type: " + type);
        }
    }

    private static final class EnumConverter<T extends Enum<T>> {
        private final boolean isCaseSensitiveEnum;
        private final Map<String, T> enumMap;

        EnumConverter(Class<T> enumClass) {
            EnumSet<T> enumInstances = EnumSet.allOf(enumClass);
            Map lowerCaseEnumMap = enumInstances.stream().collect(ImmutableMap.toImmutableMap(e -> Ascii.toLowerCase(e.name()), Function.identity(), (e1, e2) -> e1));
            if (enumInstances.size() != lowerCaseEnumMap.size()) {
                this.enumMap = enumInstances.stream().collect(ImmutableMap.toImmutableMap(Enum::name, Function.identity()));
                this.isCaseSensitiveEnum = true;
            } else {
                this.enumMap = lowerCaseEnumMap;
                this.isCaseSensitiveEnum = false;
            }
        }

        T toEnum(String str) {
            Enum result = (Enum)this.enumMap.get(this.isCaseSensitiveEnum ? str : Ascii.toLowerCase(str));
            if (result != null) {
                return (T)result;
            }
            throw new IllegalArgumentException("unknown enum value: " + str + " (expected: " + this.enumMap.values() + ')');
        }
    }

    static enum AggregationType {
        ALL,
        MULTIPART,
        NONE;

    }

    static class AggregatedResult {
        static final AggregatedResult EMPTY = new AggregatedResult(null, null);
        @Nullable
        private final FileAggregatedMultipart aggregatedMultipart;
        @Nullable
        private final AggregatedHttpRequest aggregatedHttpRequest;

        private AggregatedResult(@Nullable FileAggregatedMultipart aggregatedMultipart, @Nullable AggregatedHttpRequest aggregatedHttpRequest) {
            this.aggregatedMultipart = aggregatedMultipart;
            this.aggregatedHttpRequest = aggregatedHttpRequest;
        }

        AggregatedResult(FileAggregatedMultipart aggregatedMultipart) {
            this(aggregatedMultipart, null);
        }

        AggregatedResult(AggregatedHttpRequest aggregatedHttpRequest) {
            this(null, aggregatedHttpRequest);
        }
    }
}

