/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.internal.server.annotation;

import io.opentelemetry.testing.internal.armeria.internal.server.annotation.AnnotatedBeanFactoryRegistry;
import io.opentelemetry.testing.internal.armeria.internal.server.annotation.AnnotatedValueResolver;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.collect.ImmutableMap;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.AbstractMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

final class AnnotatedBeanFactory<T> {
    private final AnnotatedBeanFactoryRegistry.BeanFactoryId beanFactoryId;
    private final Map.Entry<Constructor<T>, List<AnnotatedValueResolver>> constructor;
    private final Map<Field, AnnotatedValueResolver> fields;
    private final Map<Method, List<AnnotatedValueResolver>> methods;

    AnnotatedBeanFactory(AnnotatedBeanFactoryRegistry.BeanFactoryId beanFactoryId, Map.Entry<Constructor<T>, List<AnnotatedValueResolver>> constructor, Map<Method, List<AnnotatedValueResolver>> methods, Map<Field, AnnotatedValueResolver> fields) {
        this.beanFactoryId = Objects.requireNonNull(beanFactoryId, "beanFactoryId");
        this.constructor = AnnotatedBeanFactory.immutableEntry(Objects.requireNonNull(constructor, "constructor"));
        this.fields = ImmutableMap.copyOf(Objects.requireNonNull(fields, "fields"));
        this.methods = ImmutableMap.copyOf(Objects.requireNonNull(methods, "methods"));
    }

    private static <K, V> Map.Entry<K, V> immutableEntry(Map.Entry<K, V> entry) {
        if (entry instanceof AbstractMap.SimpleImmutableEntry) {
            return entry;
        }
        return new AbstractMap.SimpleImmutableEntry<K, V>(entry);
    }

    T create(AnnotatedValueResolver.ResolverContext resolverContext) {
        T instance;
        Object[] constructorArgs = AnnotatedValueResolver.toArguments(this.constructor.getValue(), resolverContext);
        try {
            instance = this.constructor.getKey().newInstance(constructorArgs);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("cannot instantiate a new object: " + this.beanFactoryId, e);
        }
        for (Map.Entry<Method, List<AnnotatedValueResolver>> entry : this.methods.entrySet()) {
            Object[] methodArgs = AnnotatedValueResolver.toArguments(entry.getValue(), resolverContext);
            try {
                entry.getKey().invoke(instance, methodArgs);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("cannot invoke method: " + this.beanFactoryId + '.' + entry.getKey().getName(), e);
            }
        }
        for (Map.Entry<AccessibleObject, Object> entry : this.fields.entrySet()) {
            Object fieldArg = ((AnnotatedValueResolver)entry.getValue()).resolve(resolverContext);
            try {
                ((Field)entry.getKey()).set(instance, fieldArg);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("cannot set field: " + this.beanFactoryId + '.' + ((Field)entry.getKey()).getName(), e);
            }
        }
        return instance;
    }

    Map.Entry<Constructor<T>, List<AnnotatedValueResolver>> constructor() {
        return this.constructor;
    }

    Map<Method, List<AnnotatedValueResolver>> methods() {
        return this.methods;
    }

    Map<Field, AnnotatedValueResolver> fields() {
        return this.fields;
    }
}

