/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.internal.common.stream;

import io.opentelemetry.testing.internal.armeria.common.annotation.Nullable;
import io.opentelemetry.testing.internal.armeria.internal.common.stream.NoopSubscription;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.math.LongMath;
import io.opentelemetry.testing.internal.io.netty.util.concurrent.EventExecutor;
import java.util.Objects;
import org.reactivestreams.Subscription;

public class SubscriptionArbiter
implements Subscription {
    private final EventExecutor executor;
    @Nullable
    private Subscription newSubscription;
    @Nullable
    private Subscription subscription;
    private long newRequested;
    private long newProduced;
    private long requested;
    private int wip;

    protected SubscriptionArbiter(EventExecutor executor) {
        this.executor = executor;
    }

    @Override
    public void request(long n) {
        if (this.executor.inEventLoop()) {
            this.request0(n);
        } else {
            this.executor.execute(() -> this.request0(n));
        }
    }

    private void request0(long n) {
        this.newRequested = LongMath.saturatedAdd(this.newRequested, n);
        this.drain();
    }

    @Override
    public void cancel() {
        if (this.executor.inEventLoop()) {
            this.doCancel();
        } else {
            this.executor.execute(this::doCancel);
        }
    }

    final void doCancel() {
        NoopSubscription noopSubscription = NoopSubscription.get();
        if (this.newSubscription == null) {
            this.newSubscription = noopSubscription;
        } else if (this.newSubscription != noopSubscription) {
            Subscription oldSubscription = this.newSubscription;
            this.newSubscription = noopSubscription;
            oldSubscription.cancel();
        }
        this.drain();
    }

    public final void setUpstreamSubscription(Subscription subscription) {
        Objects.requireNonNull(subscription, "subscription");
        assert (this.executor.inEventLoop());
        Subscription previous = this.newSubscription;
        if (previous == NoopSubscription.get()) {
            subscription.cancel();
            return;
        }
        this.newSubscription = subscription;
        this.drain();
    }

    protected final void produced(long n) {
        assert (this.executor.inEventLoop());
        this.newProduced = LongMath.saturatedAdd(this.newProduced, n);
        this.drain();
    }

    private void drain() {
        if (this.wip++ > 0) {
            return;
        }
        long toRequest = 0L;
        Subscription requestFrom = null;
        do {
            boolean isCancelled;
            long newReq = this.newRequested;
            this.newRequested = 0L;
            long newProd = this.newProduced;
            this.newProduced = 0L;
            Subscription next = this.newSubscription;
            boolean bl = isCancelled = next == NoopSubscription.get();
            if (next != null) {
                this.newSubscription = null;
            }
            if (isCancelled) {
                Subscription s = this.subscription;
                this.subscription = null;
                if (s != null) {
                    s.cancel();
                }
                toRequest = 0L;
                requestFrom = null;
                continue;
            }
            long currentRequested = this.requested;
            if (newReq != 0L) {
                currentRequested = LongMath.saturatedAdd(currentRequested, newReq);
                toRequest = LongMath.saturatedAdd(toRequest, newReq);
                requestFrom = this.subscription;
            }
            if (newProd != 0L && currentRequested != Long.MAX_VALUE) {
                currentRequested = Math.max(currentRequested - newProd, 0L);
            }
            if (next != null) {
                this.subscription = next;
                requestFrom = next;
                toRequest = currentRequested;
            }
            this.requested = currentRequested;
        } while (--this.wip != 0);
        if (requestFrom != null && toRequest != 0L) {
            requestFrom.request(toRequest);
        }
    }
}

