/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.internal.common;

import io.opentelemetry.testing.internal.armeria.client.ResponseTimeoutException;
import io.opentelemetry.testing.internal.armeria.common.TimeoutException;
import io.opentelemetry.testing.internal.armeria.common.annotation.Nullable;
import io.opentelemetry.testing.internal.armeria.common.util.TimeoutMode;
import io.opentelemetry.testing.internal.armeria.common.util.UnmodifiableFuture;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.base.Preconditions;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.math.LongMath;
import io.opentelemetry.testing.internal.armeria.server.RequestTimeoutException;
import io.opentelemetry.testing.internal.io.netty.util.concurrent.EventExecutor;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;

public final class CancellationScheduler {
    private static final AtomicReferenceFieldUpdater<CancellationScheduler, CancellationFuture> whenCancellingUpdater = AtomicReferenceFieldUpdater.newUpdater(CancellationScheduler.class, CancellationFuture.class, "whenCancelling");
    private static final AtomicReferenceFieldUpdater<CancellationScheduler, CancellationFuture> whenCancelledUpdater = AtomicReferenceFieldUpdater.newUpdater(CancellationScheduler.class, CancellationFuture.class, "whenCancelled");
    private static final AtomicReferenceFieldUpdater<CancellationScheduler, TimeoutFuture> whenTimingOutUpdater = AtomicReferenceFieldUpdater.newUpdater(CancellationScheduler.class, TimeoutFuture.class, "whenTimingOut");
    private static final AtomicReferenceFieldUpdater<CancellationScheduler, TimeoutFuture> whenTimedOutUpdater = AtomicReferenceFieldUpdater.newUpdater(CancellationScheduler.class, TimeoutFuture.class, "whenTimedOut");
    private static final AtomicReferenceFieldUpdater<CancellationScheduler, Runnable> pendingTaskUpdater = AtomicReferenceFieldUpdater.newUpdater(CancellationScheduler.class, Runnable.class, "pendingTask");
    private static final AtomicLongFieldUpdater<CancellationScheduler> pendingTimeoutNanosUpdater = AtomicLongFieldUpdater.newUpdater(CancellationScheduler.class, "pendingTimeoutNanos");
    private static final Runnable noopPendingTask = () -> {};
    private State state = State.INIT;
    private long timeoutNanos;
    private long startTimeNanos;
    @Nullable
    private EventExecutor eventLoop;
    @Nullable
    private CancellationTask task;
    @Nullable
    private volatile Runnable pendingTask;
    @Nullable
    private ScheduledFuture<?> scheduledFuture;
    @Nullable
    private volatile CancellationFuture whenCancelling;
    @Nullable
    private volatile CancellationFuture whenCancelled;
    @Nullable
    private volatile TimeoutFuture whenTimingOut;
    @Nullable
    private volatile TimeoutFuture whenTimedOut;
    private volatile long pendingTimeoutNanos;
    private boolean server;
    @Nullable
    private Throwable cause;

    public CancellationScheduler(long timeoutNanos) {
        this.timeoutNanos = timeoutNanos;
        this.pendingTimeoutNanos = timeoutNanos;
    }

    public void init(EventExecutor eventLoop, CancellationTask task, long timeoutNanos, boolean server) {
        if (!eventLoop.inEventLoop()) {
            eventLoop.execute(() -> this.init0(eventLoop, task, timeoutNanos, server));
        } else {
            this.init0(eventLoop, task, timeoutNanos, server);
        }
    }

    private void init0(EventExecutor eventLoop, CancellationTask task, long timeoutNanos, boolean server) {
        block5: {
            Runnable pendingTask;
            if (this.state != State.INIT) {
                return;
            }
            this.eventLoop = eventLoop;
            this.task = task;
            if (timeoutNanos > 0L) {
                this.timeoutNanos = timeoutNanos;
            }
            this.server = server;
            this.startTimeNanos = System.nanoTime();
            if (this.timeoutNanos != 0L) {
                this.state = State.SCHEDULED;
                this.scheduledFuture = eventLoop.schedule(() -> this.invokeTask(null), this.timeoutNanos, TimeUnit.NANOSECONDS);
            } else {
                this.state = State.INACTIVE;
            }
            while (!pendingTaskUpdater.compareAndSet(this, pendingTask = this.pendingTask, noopPendingTask)) {
            }
            if (pendingTask == null) break block5;
            pendingTask.run();
        }
    }

    public void clearTimeout() {
        this.clearTimeout(true);
    }

    public void clearTimeout(boolean resetTimeout) {
        if (this.timeoutNanos() == 0L) {
            return;
        }
        if (this.isInitialized()) {
            if (this.eventLoop.inEventLoop()) {
                this.clearTimeout0(resetTimeout);
            } else {
                this.eventLoop.execute(() -> this.clearTimeout0(resetTimeout));
            }
        } else {
            if (resetTimeout) {
                this.setPendingTimeoutNanos(0L);
            }
            this.addPendingTask(() -> this.clearTimeout0(resetTimeout));
        }
    }

    private boolean clearTimeout0(boolean resetTimeout) {
        assert (this.eventLoop != null && this.eventLoop.inEventLoop());
        if (this.state != State.SCHEDULED) {
            return true;
        }
        if (resetTimeout) {
            this.timeoutNanos = 0L;
        }
        assert (this.scheduledFuture != null);
        boolean cancelled = this.scheduledFuture.cancel(false);
        this.scheduledFuture = null;
        if (cancelled) {
            this.state = State.INACTIVE;
        }
        return cancelled;
    }

    public void setTimeoutNanos(TimeoutMode mode, long timeoutNanos) {
        switch (mode) {
            case SET_FROM_NOW: {
                this.setTimeoutNanosFromNow(timeoutNanos);
                break;
            }
            case SET_FROM_START: {
                this.setTimeoutNanosFromStart(timeoutNanos);
                break;
            }
            case EXTEND: {
                this.extendTimeoutNanos(timeoutNanos);
            }
        }
    }

    private void setTimeoutNanosFromStart(long timeoutNanos) {
        Preconditions.checkArgument(timeoutNanos >= 0L, "timeoutNanos: %s (expected: >= 0)", timeoutNanos);
        if (timeoutNanos == 0L) {
            this.clearTimeout();
            return;
        }
        if (this.isInitialized()) {
            if (this.eventLoop.inEventLoop()) {
                this.setTimeoutNanosFromStart0(timeoutNanos);
            } else {
                this.eventLoop.execute(() -> this.setTimeoutNanosFromStart0(timeoutNanos));
            }
        } else {
            this.setPendingTimeoutNanos(timeoutNanos);
            this.addPendingTask(() -> this.setTimeoutNanosFromStart0(timeoutNanos));
        }
    }

    private void setTimeoutNanosFromStart0(long timeoutNanos) {
        assert (this.eventLoop != null && this.eventLoop.inEventLoop());
        long passedTimeNanos = System.nanoTime() - this.startTimeNanos;
        long newTimeoutNanos = LongMath.saturatedSubtract(timeoutNanos, passedTimeNanos);
        if (newTimeoutNanos <= 0L) {
            this.invokeTask(null);
            return;
        }
        this.clearTimeout0(true);
        this.timeoutNanos = timeoutNanos;
        this.state = State.SCHEDULED;
        this.scheduledFuture = this.eventLoop.schedule(() -> this.invokeTask(null), newTimeoutNanos, TimeUnit.NANOSECONDS);
    }

    private void extendTimeoutNanos(long adjustmentNanos) {
        if (adjustmentNanos == 0L || this.timeoutNanos() == 0L) {
            return;
        }
        if (this.isInitialized()) {
            if (this.eventLoop.inEventLoop()) {
                this.extendTimeoutNanos0(adjustmentNanos);
            } else {
                this.eventLoop.execute(() -> this.extendTimeoutNanos0(adjustmentNanos));
            }
        } else {
            this.addPendingTimeoutNanos(adjustmentNanos);
            this.addPendingTask(() -> this.extendTimeoutNanos0(adjustmentNanos));
        }
    }

    private void extendTimeoutNanos0(long adjustmentNanos) {
        assert (this.eventLoop != null && this.eventLoop.inEventLoop() && this.task != null);
        if (this.state != State.SCHEDULED || !this.task.canSchedule()) {
            return;
        }
        long timeoutNanos = this.timeoutNanos;
        this.clearTimeout0(true);
        this.timeoutNanos = LongMath.saturatedAdd(timeoutNanos, adjustmentNanos);
        if (timeoutNanos <= 0L) {
            this.invokeTask(null);
            return;
        }
        this.state = State.SCHEDULED;
        this.scheduledFuture = this.eventLoop.schedule(() -> this.invokeTask(null), this.timeoutNanos, TimeUnit.NANOSECONDS);
    }

    private void setTimeoutNanosFromNow(long timeoutNanos) {
        Preconditions.checkArgument(timeoutNanos > 0L, "timeoutNanos: %s (expected: > 0)", timeoutNanos);
        if (this.isInitialized()) {
            if (this.eventLoop.inEventLoop()) {
                this.setTimeoutNanosFromNow0(timeoutNanos);
            } else {
                long eventLoopStartTimeNanos = System.nanoTime();
                this.eventLoop.execute(() -> {
                    long passedTimeNanos0 = System.nanoTime() - eventLoopStartTimeNanos;
                    long timeoutNanos0 = Math.max(1L, timeoutNanos - passedTimeNanos0);
                    this.setTimeoutNanosFromNow0(timeoutNanos0);
                });
            }
        } else {
            long pendingTaskRegisterTimeNanos = System.nanoTime();
            this.setPendingTimeoutNanos(timeoutNanos);
            this.addPendingTask(() -> {
                long passedTimeNanos0 = System.nanoTime() - pendingTaskRegisterTimeNanos;
                long timeoutNanos0 = Math.max(1L, timeoutNanos - passedTimeNanos0);
                this.setTimeoutNanosFromNow0(timeoutNanos0);
            });
        }
    }

    private void setTimeoutNanosFromNow0(long newTimeoutNanos) {
        assert (newTimeoutNanos > 0L);
        assert (this.eventLoop != null && this.eventLoop.inEventLoop() && this.task != null);
        if (this.isFinishing() || !this.task.canSchedule()) {
            return;
        }
        this.clearTimeout0(true);
        long passedTimeNanos = System.nanoTime() - this.startTimeNanos;
        this.timeoutNanos = LongMath.saturatedAdd(newTimeoutNanos, passedTimeNanos);
        this.state = State.SCHEDULED;
        this.scheduledFuture = this.eventLoop.schedule(() -> this.invokeTask(null), newTimeoutNanos, TimeUnit.NANOSECONDS);
    }

    public void finishNow() {
        this.finishNow(null);
    }

    public void finishNow(@Nullable Throwable cause) {
        if (this.isFinishing()) {
            return;
        }
        if (this.isInitialized()) {
            if (this.eventLoop.inEventLoop()) {
                this.finishNow0(cause);
            } else {
                this.eventLoop.execute(() -> this.finishNow0(cause));
            }
        } else {
            this.addPendingTask(() -> this.finishNow0(cause));
        }
    }

    private void finishNow0(@Nullable Throwable cause) {
        assert (this.eventLoop != null && this.eventLoop.inEventLoop() && this.task != null);
        if (this.isFinishing() || !this.task.canSchedule()) {
            return;
        }
        if (this.state == State.SCHEDULED) {
            if (this.clearTimeout0(false)) {
                this.invokeTask(cause);
            }
        } else {
            this.invokeTask(cause);
        }
    }

    public boolean isFinished() {
        return this.state == State.FINISHED;
    }

    private boolean isFinishing() {
        return this.state == State.FINISHED || this.state == State.FINISHING;
    }

    @Nullable
    public Throwable cause() {
        return this.cause;
    }

    public long timeoutNanos() {
        return this.isInitialized() ? this.timeoutNanos : this.pendingTimeoutNanos;
    }

    public long startTimeNanos() {
        return this.startTimeNanos;
    }

    public CompletableFuture<Throwable> whenCancelling() {
        CancellationFuture whenCancelling = this.whenCancelling;
        if (whenCancelling != null) {
            return whenCancelling;
        }
        CancellationFuture cancellationFuture = new CancellationFuture();
        if (whenCancellingUpdater.compareAndSet(this, null, cancellationFuture)) {
            return cancellationFuture;
        }
        return this.whenCancelling;
    }

    public CompletableFuture<Throwable> whenCancelled() {
        CancellationFuture whenCancelled = this.whenCancelled;
        if (whenCancelled != null) {
            return whenCancelled;
        }
        CancellationFuture cancellationFuture = new CancellationFuture();
        if (whenCancelledUpdater.compareAndSet(this, null, cancellationFuture)) {
            return cancellationFuture;
        }
        return this.whenCancelled;
    }

    @Deprecated
    public CompletableFuture<Void> whenTimingOut() {
        TimeoutFuture whenTimingOut = this.whenTimingOut;
        if (whenTimingOut != null) {
            return whenTimingOut;
        }
        TimeoutFuture timeoutFuture = new TimeoutFuture();
        if (whenTimingOutUpdater.compareAndSet(this, null, timeoutFuture)) {
            this.whenCancelling().thenAccept(cause -> {
                if (cause instanceof TimeoutException) {
                    timeoutFuture.doComplete();
                }
            });
            return timeoutFuture;
        }
        return this.whenTimingOut;
    }

    @Deprecated
    public CompletableFuture<Void> whenTimedOut() {
        TimeoutFuture whenTimedOut = this.whenTimedOut;
        if (whenTimedOut != null) {
            return whenTimedOut;
        }
        TimeoutFuture timeoutFuture = new TimeoutFuture();
        if (whenTimedOutUpdater.compareAndSet(this, null, timeoutFuture)) {
            this.whenCancelled().thenAccept(cause -> {
                if (cause instanceof TimeoutException) {
                    timeoutFuture.doComplete();
                }
            });
            return timeoutFuture;
        }
        return this.whenTimedOut;
    }

    public boolean isInitialized() {
        return this.pendingTask == noopPendingTask && this.eventLoop != null;
    }

    private void addPendingTask(Runnable pendingTask) {
        block3: {
            Runnable newPendingTask;
            Runnable oldPendingTask;
            if (pendingTaskUpdater.compareAndSet(this, null, pendingTask)) break block3;
            do {
                oldPendingTask = this.pendingTask;
                assert (oldPendingTask != null);
                if (oldPendingTask != noopPendingTask) continue;
                assert (this.eventLoop != null);
                this.eventLoop.execute(pendingTask);
                break;
            } while (!pendingTaskUpdater.compareAndSet(this, oldPendingTask, newPendingTask = () -> {
                oldPendingTask.run();
                pendingTask.run();
            }));
        }
    }

    private void setPendingTimeoutNanos(long pendingTimeoutNanos) {
        long oldPendingTimeoutNanos;
        while (!pendingTimeoutNanosUpdater.compareAndSet(this, oldPendingTimeoutNanos = this.pendingTimeoutNanos, pendingTimeoutNanos)) {
        }
    }

    private void addPendingTimeoutNanos(long pendingTimeoutNanos) {
        long newPendingTimeoutNanos;
        long oldPendingTimeoutNanos;
        while (!pendingTimeoutNanosUpdater.compareAndSet(this, oldPendingTimeoutNanos = this.pendingTimeoutNanos, newPendingTimeoutNanos = LongMath.saturatedAdd(oldPendingTimeoutNanos, pendingTimeoutNanos))) {
        }
    }

    private void invokeTask(@Nullable Throwable cause) {
        if (this.task == null) {
            return;
        }
        if (cause == null) {
            cause = this.server ? RequestTimeoutException.get() : ResponseTimeoutException.get();
        }
        this.state = State.FINISHING;
        if (this.task.canSchedule()) {
            ((CancellationFuture)this.whenCancelling()).doComplete(cause);
        }
        this.state = State.FINISHED;
        if (this.task.canSchedule()) {
            this.task.run(cause);
        }
        this.cause = cause;
        ((CancellationFuture)this.whenCancelled()).doComplete(cause);
    }

    State state() {
        return this.state;
    }

    static enum State {
        INIT,
        INACTIVE,
        SCHEDULED,
        FINISHING,
        FINISHED;

    }

    public static interface CancellationTask {
        public boolean canSchedule();

        public void run(Throwable var1);
    }

    private static class CancellationFuture
    extends UnmodifiableFuture<Throwable> {
        private CancellationFuture() {
        }

        @Override
        protected void doComplete(@Nullable Throwable cause) {
            super.doComplete(cause);
        }
    }

    private static class TimeoutFuture
    extends UnmodifiableFuture<Void> {
        private TimeoutFuture() {
        }

        void doComplete() {
            this.doComplete(null);
        }
    }
}

