/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.internal.common;

import io.opentelemetry.testing.internal.armeria.common.annotation.Nullable;
import io.opentelemetry.testing.internal.armeria.common.util.Exceptions;
import io.opentelemetry.testing.internal.armeria.internal.common.KeepAliveHandler;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.base.Stopwatch;
import io.opentelemetry.testing.internal.io.micrometer.core.instrument.Timer;
import io.opentelemetry.testing.internal.io.netty.channel.Channel;
import io.opentelemetry.testing.internal.io.netty.channel.ChannelFuture;
import io.opentelemetry.testing.internal.io.netty.channel.ChannelFutureListener;
import io.opentelemetry.testing.internal.io.netty.channel.ChannelHandlerContext;
import io.opentelemetry.testing.internal.io.netty.channel.EventLoop;
import io.opentelemetry.testing.internal.io.netty.util.concurrent.Future;
import io.opentelemetry.testing.internal.io.netty.util.concurrent.GenericFutureListener;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractKeepAliveHandler
implements KeepAliveHandler {
    private static final Logger logger = LoggerFactory.getLogger(AbstractKeepAliveHandler.class);
    @Nullable
    private final Stopwatch stopwatch = logger.isDebugEnabled() ? Stopwatch.createUnstarted() : null;
    private final ChannelFutureListener pingWriteListener = new PingWriteListener();
    private final Runnable shutdownRunnable = this::closeChannelAndLog;
    private final Channel channel;
    private final String name;
    private final boolean isServer;
    private final Timer keepAliveTimer;
    private final long maxNumRequestsPerConnection;
    private long currentNumRequests;
    @Nullable
    private ScheduledFuture<?> connectionIdleTimeout;
    private final long connectionIdleTimeNanos;
    private long lastConnectionIdleTime;
    private final boolean keepAliveOnPing;
    @Nullable
    private ScheduledFuture<?> pingIdleTimeout;
    private final long pingIdleTimeNanos;
    private long lastPingIdleTime;
    private boolean firstPingIdleEvent = true;
    @Nullable
    private ScheduledFuture<?> maxConnectionAgeFuture;
    private final long maxConnectionAgeNanos;
    private boolean isMaxConnectionAgeExceeded;
    private boolean isInitialized;
    private boolean closed;
    private boolean disconnectWhenFinished;
    private PingState pingState = PingState.IDLE;
    @Nullable
    private ChannelFuture pingWriteFuture;
    @Nullable
    private java.util.concurrent.Future<?> shutdownFuture;

    protected AbstractKeepAliveHandler(Channel channel, String name, Timer keepAliveTimer, long idleTimeoutMillis, long pingIntervalMillis, long maxConnectionAgeMillis, long maxNumRequestsPerConnection, boolean keepAliveOnPing) {
        this.channel = channel;
        this.name = name;
        this.isServer = "server".equals(name);
        this.keepAliveTimer = keepAliveTimer;
        this.maxNumRequestsPerConnection = maxNumRequestsPerConnection;
        this.keepAliveOnPing = keepAliveOnPing;
        this.connectionIdleTimeNanos = idleTimeoutMillis <= 0L ? 0L : TimeUnit.MILLISECONDS.toNanos(idleTimeoutMillis);
        this.pingIdleTimeNanos = pingIntervalMillis <= 0L ? 0L : TimeUnit.MILLISECONDS.toNanos(pingIntervalMillis);
        this.maxConnectionAgeNanos = maxConnectionAgeMillis <= 0L ? 0L : TimeUnit.MILLISECONDS.toNanos(maxConnectionAgeMillis);
    }

    @Override
    public final void initialize(ChannelHandlerContext ctx) {
        if (this.isInitialized) {
            return;
        }
        this.isInitialized = true;
        long connectionStartTimeNanos = System.nanoTime();
        ctx.channel().closeFuture().addListener((GenericFutureListener<? extends Future<? super Void>>)((GenericFutureListener<Future>)unused -> {
            this.keepAliveTimer.record(System.nanoTime() - connectionStartTimeNanos, TimeUnit.NANOSECONDS);
            this.destroy();
        }));
        this.lastConnectionIdleTime = this.lastPingIdleTime = connectionStartTimeNanos;
        if (this.connectionIdleTimeNanos > 0L) {
            this.connectionIdleTimeout = this.executor().schedule(new ConnectionIdleTimeoutTask(ctx), this.connectionIdleTimeNanos, TimeUnit.NANOSECONDS);
        }
        if (this.pingIdleTimeNanos > 0L) {
            this.pingIdleTimeout = this.executor().schedule(new PingIdleTimeoutTask(ctx), this.pingIdleTimeNanos, TimeUnit.NANOSECONDS);
        }
        if (this.maxConnectionAgeNanos > 0L) {
            this.maxConnectionAgeFuture = this.executor().schedule(new MaxConnectionAgeExceededTask(ctx), this.maxConnectionAgeNanos, TimeUnit.NANOSECONDS);
        }
    }

    @Override
    public final void destroy() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        this.isInitialized = true;
        if (this.connectionIdleTimeout != null) {
            this.connectionIdleTimeout.cancel(false);
            this.connectionIdleTimeout = null;
        }
        if (this.pingIdleTimeout != null) {
            this.pingIdleTimeout.cancel(false);
            this.pingIdleTimeout = null;
        }
        if (this.maxConnectionAgeFuture != null) {
            this.maxConnectionAgeFuture.cancel(false);
            this.maxConnectionAgeFuture = null;
        }
        this.pingState = PingState.SHUTDOWN;
        this.isMaxConnectionAgeExceeded = true;
        this.cancelFutures();
    }

    @Override
    public final void onReadOrWrite() {
        if (this.pingState == PingState.SHUTDOWN) {
            return;
        }
        if (this.connectionIdleTimeNanos > 0L) {
            this.lastConnectionIdleTime = System.nanoTime();
        }
        if (this.pingResetsPreviousPing()) {
            if (this.pingIdleTimeNanos > 0L) {
                this.lastPingIdleTime = System.nanoTime();
                this.firstPingIdleEvent = true;
            }
            this.pingState = PingState.IDLE;
            this.cancelFutures();
        }
    }

    @Override
    public final void onPing() {
        if (this.pingState == PingState.SHUTDOWN) {
            return;
        }
        if (this.connectionIdleTimeNanos > 0L && this.keepAliveOnPing) {
            this.lastConnectionIdleTime = System.nanoTime();
        }
        if (this.pingIdleTimeNanos > 0L) {
            this.firstPingIdleEvent = true;
            this.lastPingIdleTime = System.nanoTime();
        }
        this.pingState = PingState.IDLE;
        this.cancelFutures();
    }

    @Override
    public final boolean isClosing() {
        return this.pingState == PingState.SHUTDOWN;
    }

    @Override
    public void disconnectWhenFinished() {
        this.disconnectWhenFinished = true;
    }

    @Override
    public final boolean needsDisconnection() {
        return this.disconnectWhenFinished || this.pingState == PingState.SHUTDOWN || this.isMaxConnectionAgeExceeded || this.currentNumRequests > 0L && this.currentNumRequests >= this.maxNumRequestsPerConnection;
    }

    @Override
    public final void increaseNumRequests() {
        if (this.maxNumRequestsPerConnection == 0L) {
            return;
        }
        ++this.currentNumRequests;
    }

    protected abstract ChannelFuture writePing(ChannelHandlerContext var1);

    protected abstract boolean pingResetsPreviousPing();

    protected abstract boolean hasRequestsInProgress(ChannelHandlerContext var1);

    @Nullable
    protected final java.util.concurrent.Future<?> shutdownFuture() {
        return this.shutdownFuture;
    }

    protected final boolean isPendingPingAck() {
        return this.pingState == PingState.PENDING_PING_ACK;
    }

    final PingState state() {
        return this.pingState;
    }

    private void cancelFutures() {
        if (this.shutdownFuture != null) {
            this.shutdownFuture.cancel(false);
            this.shutdownFuture = null;
        }
        if (this.pingWriteFuture != null) {
            this.pingWriteFuture.cancel(false);
            this.pingWriteFuture = null;
        }
    }

    private void closeChannelAndLog() {
        if (this.pingState == PingState.SHUTDOWN) {
            return;
        }
        logger.debug("{} Closing an idle channel", (Object)this.channel);
        this.pingState = PingState.SHUTDOWN;
        this.channel.close().addListener((GenericFutureListener<? extends Future<? super Void>>)((GenericFutureListener<Future>)future -> {
            if (future.isSuccess()) {
                logger.debug("{} Closed an idle channel", (Object)this.channel);
            } else {
                logger.debug("{} Failed to close an idle channel", (Object)this.channel, (Object)future.cause());
            }
        }));
    }

    private ScheduledExecutorService executor() {
        return this.channel.eventLoop();
    }

    static enum PingState {
        IDLE,
        PING_SCHEDULED,
        PENDING_PING_ACK,
        SHUTDOWN;

    }

    private class PingWriteListener
    implements ChannelFutureListener {
        private PingWriteListener() {
        }

        @Override
        public void operationComplete(ChannelFuture future) throws Exception {
            if (future.isSuccess()) {
                logger.debug("{} PING write successful", (Object)AbstractKeepAliveHandler.this.channel);
                EventLoop el = AbstractKeepAliveHandler.this.channel.eventLoop();
                AbstractKeepAliveHandler.this.shutdownFuture = el.schedule(AbstractKeepAliveHandler.this.shutdownRunnable, AbstractKeepAliveHandler.this.pingIdleTimeNanos, TimeUnit.NANOSECONDS);
                AbstractKeepAliveHandler.this.pingState = PingState.PENDING_PING_ACK;
                this.resetStopwatch();
            } else {
                if (!future.isCancelled() && Exceptions.isExpected(future.cause())) {
                    logger.debug("{} PING write failed", (Object)AbstractKeepAliveHandler.this.channel, (Object)future.cause());
                }
                if (AbstractKeepAliveHandler.this.pingState != PingState.SHUTDOWN) {
                    AbstractKeepAliveHandler.this.pingState = PingState.IDLE;
                }
            }
        }

        private void resetStopwatch() {
            if (AbstractKeepAliveHandler.this.stopwatch != null) {
                AbstractKeepAliveHandler.this.stopwatch.reset().start();
            }
        }
    }

    private final class ConnectionIdleTimeoutTask
    extends AbstractKeepAliveTask {
        private boolean warn;

        ConnectionIdleTimeoutTask(ChannelHandlerContext ctx) {
            super(ctx);
        }

        @Override
        protected void run(ChannelHandlerContext ctx) {
            block6: {
                if (AbstractKeepAliveHandler.this.pingState == PingState.SHUTDOWN) {
                    return;
                }
                long lastConnectionIdleTime = AbstractKeepAliveHandler.this.lastConnectionIdleTime;
                long nextDelay = AbstractKeepAliveHandler.this.connectionIdleTimeNanos - (System.nanoTime() - lastConnectionIdleTime);
                if (nextDelay <= 0L) {
                    AbstractKeepAliveHandler.this.connectionIdleTimeout = AbstractKeepAliveHandler.this.executor().schedule(this, AbstractKeepAliveHandler.this.connectionIdleTimeNanos, TimeUnit.NANOSECONDS);
                    try {
                        if (!AbstractKeepAliveHandler.this.hasRequestsInProgress(ctx)) {
                            AbstractKeepAliveHandler.this.pingState = PingState.SHUTDOWN;
                            logger.debug("{} Closing an idle {} connection", (Object)ctx.channel(), (Object)AbstractKeepAliveHandler.this.name);
                            ctx.channel().close();
                        }
                        break block6;
                    }
                    catch (Exception e) {
                        if (!this.warn) {
                            logger.warn("An error occurred while notifying an all idle event", (Throwable)e);
                            this.warn = true;
                        }
                        break block6;
                    }
                }
                AbstractKeepAliveHandler.this.connectionIdleTimeout = AbstractKeepAliveHandler.this.executor().schedule(this, nextDelay, TimeUnit.NANOSECONDS);
            }
        }
    }

    private final class PingIdleTimeoutTask
    extends AbstractKeepAliveTask {
        private boolean warn;

        PingIdleTimeoutTask(ChannelHandlerContext ctx) {
            super(ctx);
        }

        @Override
        protected void run(ChannelHandlerContext ctx) {
            block5: {
                long lastPingIdleTime = AbstractKeepAliveHandler.this.lastPingIdleTime;
                long nextDelay = AbstractKeepAliveHandler.this.pingIdleTimeNanos - (System.nanoTime() - lastPingIdleTime);
                if (nextDelay <= 0L) {
                    AbstractKeepAliveHandler.this.pingIdleTimeout = AbstractKeepAliveHandler.this.executor().schedule(this, AbstractKeepAliveHandler.this.pingIdleTimeNanos, TimeUnit.NANOSECONDS);
                    boolean isFirst = AbstractKeepAliveHandler.this.firstPingIdleEvent;
                    AbstractKeepAliveHandler.this.firstPingIdleEvent = false;
                    try {
                        if (AbstractKeepAliveHandler.this.pingIdleTimeNanos > 0L && isFirst) {
                            AbstractKeepAliveHandler.this.pingState = PingState.PING_SCHEDULED;
                            AbstractKeepAliveHandler.this.writePing(ctx).addListener(AbstractKeepAliveHandler.this.pingWriteListener);
                        }
                        break block5;
                    }
                    catch (Exception e) {
                        if (!this.warn) {
                            logger.warn("An error occurred while notifying a ping idle event", (Throwable)e);
                            this.warn = true;
                        }
                        break block5;
                    }
                }
                AbstractKeepAliveHandler.this.pingIdleTimeout = AbstractKeepAliveHandler.this.executor().schedule(this, nextDelay, TimeUnit.NANOSECONDS);
            }
        }
    }

    private final class MaxConnectionAgeExceededTask
    extends AbstractKeepAliveTask {
        MaxConnectionAgeExceededTask(ChannelHandlerContext ctx) {
            super(ctx);
        }

        @Override
        protected void run(ChannelHandlerContext ctx) {
            try {
                AbstractKeepAliveHandler.this.isMaxConnectionAgeExceeded = true;
                if (!AbstractKeepAliveHandler.this.isServer && !AbstractKeepAliveHandler.this.hasRequestsInProgress(ctx)) {
                    logger.debug("{} Closing a {} connection exceeding the max age: {}ns", new Object[]{ctx.channel(), AbstractKeepAliveHandler.this.name, AbstractKeepAliveHandler.this.maxConnectionAgeNanos});
                    ctx.channel().close();
                }
            }
            catch (Exception e) {
                logger.warn("Unexpected error occurred while closing a connection exceeding the max age", (Throwable)e);
            }
        }
    }

    private static abstract class AbstractKeepAliveTask
    implements Runnable {
        private final ChannelHandlerContext ctx;

        AbstractKeepAliveTask(ChannelHandlerContext ctx) {
            this.ctx = ctx;
        }

        @Override
        public void run() {
            if (!this.ctx.channel().isOpen()) {
                return;
            }
            this.run(this.ctx);
        }

        protected abstract void run(ChannelHandlerContext var1);
    }
}

