/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.internal.client.dns;

import io.opentelemetry.testing.internal.armeria.common.annotation.Nullable;
import io.opentelemetry.testing.internal.armeria.common.util.AbstractUnwrappable;
import io.opentelemetry.testing.internal.armeria.common.util.UnmodifiableFuture;
import io.opentelemetry.testing.internal.armeria.internal.client.dns.DnsQuestionContext;
import io.opentelemetry.testing.internal.armeria.internal.client.dns.DnsQuestionWithoutTrailingDot;
import io.opentelemetry.testing.internal.armeria.internal.client.dns.DnsResolver;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.base.Strings;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.collect.ImmutableList;
import io.opentelemetry.testing.internal.io.netty.handler.codec.dns.DnsQuestion;
import io.opentelemetry.testing.internal.io.netty.handler.codec.dns.DnsRecord;
import io.opentelemetry.testing.internal.io.netty.handler.codec.dns.DnsRecordType;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class SearchDomainDnsResolver
extends AbstractUnwrappable<DnsResolver>
implements DnsResolver {
    private static final Logger logger = LoggerFactory.getLogger(SearchDomainDnsResolver.class);
    private final List<String> searchDomains;
    private final int ndots;
    private volatile boolean closed;

    SearchDomainDnsResolver(DnsResolver delegate, List<String> searchDomains, int ndots) {
        super(delegate);
        this.searchDomains = SearchDomainDnsResolver.validateSearchDomain(searchDomains);
        this.ndots = ndots;
    }

    private static List<String> validateSearchDomain(List<String> searchDomains) {
        return searchDomains.stream().map(searchDomain -> {
            if (Strings.isNullOrEmpty(searchDomain) || ".".equals(searchDomain)) {
                return null;
            }
            String normalized = searchDomain;
            if (searchDomain.charAt(0) != '.') {
                normalized = '.' + searchDomain;
            }
            if (searchDomain.charAt(searchDomain.length() - 1) != '.') {
                normalized = normalized + '.';
            }
            try {
                DnsQuestionWithoutTrailingDot.of("localhost" + normalized, DnsRecordType.A);
                return normalized;
            }
            catch (Exception ex) {
                logger.warn("Ignoring a malformed search domain: '{}'", searchDomain, (Object)ex);
                return null;
            }
        }).filter(Objects::nonNull).collect(ImmutableList.toImmutableList());
    }

    @Override
    public CompletableFuture<List<DnsRecord>> resolve(DnsQuestionContext ctx, DnsQuestion question) {
        SearchDomainQuestionContext searchDomainCtx = new SearchDomainQuestionContext(question, this.searchDomains, this.ndots);
        DnsQuestion firstQuestion = searchDomainCtx.nextQuestion();
        assert (firstQuestion != null);
        return this.resolve0(ctx, searchDomainCtx, firstQuestion);
    }

    private CompletableFuture<List<DnsRecord>> resolve0(DnsQuestionContext ctx, SearchDomainQuestionContext searchDomainCtx, DnsQuestion question) {
        if (this.closed) {
            return UnmodifiableFuture.exceptionallyCompletedFuture(new IllegalStateException("resolver is closed already"));
        }
        return ((CompletableFuture)((DnsResolver)this.unwrap()).resolve(ctx, question).handle((records, cause) -> {
            if (records != null) {
                return UnmodifiableFuture.completedFuture(records);
            }
            DnsQuestion nextQuestion = searchDomainCtx.nextQuestion();
            if (nextQuestion != null) {
                return this.resolve0(ctx, searchDomainCtx, nextQuestion);
            }
            return UnmodifiableFuture.exceptionallyCompletedFuture(cause);
        })).thenCompose(Function.identity());
    }

    @Override
    public void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        ((DnsResolver)this.unwrap()).close();
    }

    static final class SearchDomainQuestionContext {
        private final DnsQuestion original;
        private final String originalName;
        private final List<String> searchDomains;
        private final boolean shouldStartWithHostname;
        private volatile int numAttemptsSoFar;

        SearchDomainQuestionContext(DnsQuestion original, List<String> searchDomains, int ndots) {
            this.original = original;
            this.searchDomains = searchDomains;
            this.originalName = original.name();
            this.shouldStartWithHostname = SearchDomainQuestionContext.hasNDots(this.originalName, ndots);
        }

        private static boolean hasNDots(String hostname, int ndots) {
            int dots = 0;
            for (int idx = hostname.length() - 1; idx >= 0; --idx) {
                if (hostname.charAt(idx) != '.' || ++dots < ndots) continue;
                return true;
            }
            return false;
        }

        @Nullable
        DnsQuestion nextQuestion() {
            DnsQuestion dnsQuestion = this.nextQuestion0();
            if (dnsQuestion != null) {
                ++this.numAttemptsSoFar;
            }
            return dnsQuestion;
        }

        @Nullable
        private DnsQuestion nextQuestion0() {
            int numAttemptsSoFar = this.numAttemptsSoFar;
            if (numAttemptsSoFar == 0) {
                if (this.originalName.endsWith(".") || this.searchDomains.isEmpty()) {
                    return this.original;
                }
                if (this.shouldStartWithHostname) {
                    return this.newQuestion(this.originalName + '.');
                }
                return this.newQuestion(this.originalName + this.searchDomains.get(0));
            }
            int nextSearchDomainPos = numAttemptsSoFar;
            if (this.shouldStartWithHostname) {
                nextSearchDomainPos = numAttemptsSoFar - 1;
            }
            if (nextSearchDomainPos < this.searchDomains.size()) {
                return this.newQuestion(this.originalName + this.searchDomains.get(nextSearchDomainPos));
            }
            if (nextSearchDomainPos == this.searchDomains.size() && !this.shouldStartWithHostname) {
                return this.newQuestion(this.originalName + '.');
            }
            return null;
        }

        private DnsQuestion newQuestion(String hostname) {
            return DnsQuestionWithoutTrailingDot.of(this.originalName, hostname, this.original.type());
        }
    }
}

