/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.internal.client;

import io.opentelemetry.testing.internal.armeria.common.HttpData;
import io.opentelemetry.testing.internal.armeria.common.HttpObject;
import io.opentelemetry.testing.internal.armeria.common.annotation.Nullable;
import io.opentelemetry.testing.internal.armeria.internal.common.DefaultHttpResponse;
import io.opentelemetry.testing.internal.armeria.internal.common.InboundTrafficController;
import io.opentelemetry.testing.internal.io.netty.channel.EventLoop;
import io.opentelemetry.testing.internal.io.netty.util.concurrent.EventExecutor;

public final class DecodedHttpResponse
extends DefaultHttpResponse {
    private final EventLoop eventLoop;
    @Nullable
    private InboundTrafficController inboundTrafficController;
    private long writtenBytes;

    public DecodedHttpResponse(EventLoop eventLoop) {
        this.eventLoop = eventLoop;
    }

    public void init(InboundTrafficController inboundTrafficController) {
        this.inboundTrafficController = inboundTrafficController;
    }

    public long writtenBytes() {
        return this.writtenBytes;
    }

    @Override
    public EventExecutor defaultSubscriberExecutor() {
        return this.eventLoop;
    }

    @Override
    public boolean tryWrite(HttpObject obj) {
        boolean published = super.tryWrite(obj);
        if (published && obj instanceof HttpData) {
            int length = ((HttpData)obj).length();
            assert (this.inboundTrafficController != null);
            this.inboundTrafficController.inc(length);
            this.writtenBytes += (long)length;
        }
        return published;
    }

    @Override
    protected void onRemoval(HttpObject obj) {
        if (obj instanceof HttpData) {
            int length = ((HttpData)obj).length();
            assert (this.inboundTrafficController != null);
            this.inboundTrafficController.dec(length);
        }
    }
}

