/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.internal.client;

import io.opentelemetry.testing.internal.armeria.common.AggregatedHttpRequest;
import io.opentelemetry.testing.internal.armeria.common.ByteBufAccessMode;
import io.opentelemetry.testing.internal.armeria.common.HttpData;
import io.opentelemetry.testing.internal.armeria.common.HttpRequest;
import io.opentelemetry.testing.internal.armeria.common.HttpRequestDuplicator;
import io.opentelemetry.testing.internal.armeria.common.RequestHeaders;

public final class AggregatedHttpRequestDuplicator
implements HttpRequestDuplicator {
    private final AggregatedHttpRequest request;

    public AggregatedHttpRequestDuplicator(AggregatedHttpRequest request) {
        this.request = request;
    }

    @Override
    public RequestHeaders headers() {
        return this.request.headers();
    }

    @Override
    public HttpRequest duplicate() {
        return this.duplicate(this.request.headers());
    }

    @Override
    public HttpRequest duplicate(RequestHeaders newHeaders) {
        HttpData content = this.request.content();
        if (!content.isPooled()) {
            return HttpRequest.of(newHeaders, content, this.request.trailers());
        }
        content = HttpData.wrap(content.byteBuf(ByteBufAccessMode.RETAINED_DUPLICATE));
        return HttpRequest.of(newHeaders, content, this.request.trailers());
    }

    @Override
    public void close() {
        this.request.content().close();
    }

    @Override
    public void abort() {
        this.close();
    }

    @Override
    public void abort(Throwable cause) {
        this.close();
    }
}

