/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.common.websocket;

import io.opentelemetry.testing.internal.armeria.common.annotation.Nullable;
import io.opentelemetry.testing.internal.armeria.common.websocket.WebSocketFrame;
import io.opentelemetry.testing.internal.armeria.common.websocket.WebSocketFrameType;
import io.opentelemetry.testing.internal.armeria.internal.common.ByteArrayBytes;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.base.MoreObjects;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;

class ByteArrayWebSocketFrame
extends ByteArrayBytes
implements WebSocketFrame {
    private static final byte[] EMPTY_BYTES = new byte[0];
    static final WebSocketFrame EMPTY_PING = new ByteArrayWebSocketFrame(EMPTY_BYTES, WebSocketFrameType.PING);
    static final WebSocketFrame EMPTY_PONG = new ByteArrayWebSocketFrame(EMPTY_BYTES, WebSocketFrameType.PONG);
    private final WebSocketFrameType type;
    private final boolean finalFragment;
    @Nullable
    private String text;

    ByteArrayWebSocketFrame(byte[] array, WebSocketFrameType type) {
        this(array, type, true);
    }

    ByteArrayWebSocketFrame(byte[] array, WebSocketFrameType type, boolean finalFragment) {
        this(array, type, finalFragment, null);
    }

    ByteArrayWebSocketFrame(byte[] array, WebSocketFrameType type, boolean finalFragment, @Nullable String text) {
        super(array);
        this.type = type;
        this.finalFragment = finalFragment;
        this.text = text;
    }

    @Override
    public WebSocketFrameType type() {
        return this.type;
    }

    @Override
    public boolean isFinalFragment() {
        return this.finalFragment;
    }

    @Override
    public String text() {
        if (this.text != null) {
            return this.text;
        }
        this.text = this.toString(StandardCharsets.UTF_8);
        return this.text;
    }

    @Override
    public int hashCode() {
        return (super.hashCode() * 31 + this.type.hashCode()) * 31 + Boolean.hashCode(this.finalFragment);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof WebSocketFrame)) {
            return false;
        }
        WebSocketFrame that = (WebSocketFrame)o;
        if (this.length() != that.length()) {
            return false;
        }
        return this.type == that.type() && this.finalFragment == that.isFinalFragment() && Arrays.equals(this.array(), that.array());
    }

    @Override
    public String toString() {
        return this.toString(super.toString());
    }

    private String toString(String bytes) {
        return MoreObjects.toStringHelper(this).omitNullValues().add("type", (Object)this.type).add("finalFragment", this.finalFragment).add("bytes", bytes).toString();
    }
}

