/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.common.util;

import com.google.errorprone.annotations.concurrent.GuardedBy;
import io.opentelemetry.testing.internal.armeria.common.annotation.Nullable;
import io.opentelemetry.testing.internal.armeria.common.util.Listenable;
import io.opentelemetry.testing.internal.armeria.internal.common.util.IdentityHashStrategy;
import io.opentelemetry.testing.internal.armeria.internal.common.util.ReentrantShortLock;
import io.opentelemetry.testing.internal.armeria.internal.shaded.fastutil.objects.ObjectLinkedOpenCustomHashSet;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;

public abstract class AbstractListenable<T>
implements Listenable<T> {
    private static final Consumer[] EMPTY_LISTENERS = new Consumer[0];
    @GuardedBy(value="reentrantLock")
    private final Set<Consumer<? super T>> updateListeners = new ObjectLinkedOpenCustomHashSet(IdentityHashStrategy.of());
    private final ReentrantLock reentrantLock = new ReentrantShortLock();

    protected final void notifyListeners(T latestValue) {
        Consumer[] updateListeners;
        this.reentrantLock.lock();
        try {
            updateListeners = this.updateListeners.toArray(EMPTY_LISTENERS);
        }
        finally {
            this.reentrantLock.unlock();
        }
        for (Consumer listener : updateListeners) {
            listener.accept(latestValue);
        }
    }

    @Nullable
    protected T latestValue() {
        return null;
    }

    @Override
    public final void addListener(Consumer<? super T> listener) {
        this.addListener(listener, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addListener(Consumer<? super T> listener, boolean notifyLatestValue) {
        Objects.requireNonNull(listener, "listener");
        this.reentrantLock.lock();
        try {
            T latest;
            if (notifyLatestValue && (latest = this.latestValue()) != null) {
                listener.accept(latest);
            }
            this.updateListeners.add(listener);
        }
        finally {
            this.reentrantLock.unlock();
        }
    }

    @Override
    public final void removeListener(Consumer<?> listener) {
        Objects.requireNonNull(listener, "listener");
        this.reentrantLock.lock();
        try {
            this.updateListeners.remove(listener);
        }
        finally {
            this.reentrantLock.unlock();
        }
    }
}

