/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.common.stream;

import io.opentelemetry.testing.internal.armeria.common.annotation.UnstableApi;
import io.opentelemetry.testing.internal.armeria.common.stream.DeferredStreamMessage;
import io.opentelemetry.testing.internal.armeria.common.stream.StreamMessage;
import io.opentelemetry.testing.internal.armeria.common.util.Exceptions;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Publisher;

final class StreamMessageUtil {
    @UnstableApi
    static <T> StreamMessage<T> createStreamMessageFrom(CompletableFuture<? extends Publisher<? extends T>> future) {
        Objects.requireNonNull(future, "future");
        if (future.isDone()) {
            if (!future.isCompletedExceptionally()) {
                Publisher publisher = future.getNow(null);
                return StreamMessage.of(publisher);
            }
            try {
                future.join();
                throw new Error();
            }
            catch (Throwable cause) {
                return StreamMessage.aborted(Exceptions.peel(cause));
            }
        }
        DeferredStreamMessage<Object> deferred = new DeferredStreamMessage<Object>();
        deferred.delegateOnCompletion(future);
        return deferred;
    }

    private StreamMessageUtil() {
    }
}

