/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.common.stream;

import io.opentelemetry.testing.internal.armeria.common.annotation.Nullable;
import io.opentelemetry.testing.internal.armeria.common.stream.SubscriptionOption;
import io.opentelemetry.testing.internal.armeria.internal.common.stream.InternalStreamMessageUtil;
import io.opentelemetry.testing.internal.armeria.internal.common.stream.StreamMessageUtil;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.collect.ImmutableCollection;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

final class StreamMessageCollector<T>
implements Subscriber<T> {
    private final CompletableFuture<List<T>> future = new CompletableFuture();
    private final boolean withPooledObjects;
    @Nullable
    private ImmutableList.Builder<T> elementsBuilder = ImmutableList.builder();

    StreamMessageCollector(SubscriptionOption ... options) {
        this.withPooledObjects = InternalStreamMessageUtil.containsWithPooledObjects(options);
    }

    CompletableFuture<List<T>> collect() {
        return this.future;
    }

    @Override
    public void onSubscribe(Subscription s) {
        s.request(Long.MAX_VALUE);
    }

    @Override
    public void onNext(T o) {
        Objects.requireNonNull(o, "o");
        this.elementsBuilder.add((Object)StreamMessageUtil.touchOrCopyAndClose(o, this.withPooledObjects));
    }

    @Override
    public void onComplete() {
        if (this.future.isDone()) {
            return;
        }
        this.future.complete((List<ImmutableCollection>)((Object)this.elementsBuilder.build()));
        this.elementsBuilder = null;
    }

    @Override
    public void onError(Throwable t) {
        if (this.future.isDone()) {
            return;
        }
        ImmutableCollection elements = this.elementsBuilder.build();
        for (Object element : elements) {
            StreamMessageUtil.closeOrAbort(element, t);
        }
        this.future.completeExceptionally(t);
        this.elementsBuilder = null;
    }
}

