/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.common.multipart;

import io.opentelemetry.testing.internal.armeria.common.HttpHeaders;
import io.opentelemetry.testing.internal.armeria.common.annotation.UnstableApi;
import io.opentelemetry.testing.internal.armeria.common.multipart.DefaultMultipartFile;
import java.io.File;
import java.nio.file.Path;
import java.util.Objects;

public interface MultipartFile {
    public static MultipartFile of(String name, String filename, File file) {
        Objects.requireNonNull(file, "file");
        return MultipartFile.of(name, filename, file.toPath());
    }

    public static MultipartFile of(String name, String filename, Path path) {
        return MultipartFile.of(name, filename, path, HttpHeaders.of());
    }

    @UnstableApi
    public static MultipartFile of(String name, String filename, File file, HttpHeaders headers) {
        Objects.requireNonNull(file, "file");
        return MultipartFile.of(name, filename, file.toPath(), headers);
    }

    @UnstableApi
    public static MultipartFile of(String name, String filename, Path path, HttpHeaders headers) {
        Objects.requireNonNull(name, "name");
        Objects.requireNonNull(filename, "filename");
        Objects.requireNonNull(path, "path");
        Objects.requireNonNull(headers, "headers");
        return new DefaultMultipartFile(name, filename, path, headers);
    }

    public String name();

    public String filename();

    public HttpHeaders headers();

    default public File file() {
        return this.path().toFile();
    }

    public Path path();
}

