/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.common.multipart;

import io.opentelemetry.testing.internal.armeria.common.HttpData;
import io.opentelemetry.testing.internal.armeria.common.HttpHeaders;
import io.opentelemetry.testing.internal.armeria.common.annotation.Nullable;
import io.opentelemetry.testing.internal.armeria.common.multipart.AggregatedBodyPart;
import io.opentelemetry.testing.internal.armeria.common.multipart.BodyPart;
import io.opentelemetry.testing.internal.armeria.common.stream.ByteStreamMessage;
import io.opentelemetry.testing.internal.armeria.common.stream.StreamMessage;
import io.opentelemetry.testing.internal.armeria.common.stream.StreamMessages;
import io.opentelemetry.testing.internal.armeria.internal.common.HttpObjectAggregator;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.base.MoreObjects;
import io.opentelemetry.testing.internal.io.netty.buffer.ByteBufAllocator;
import io.opentelemetry.testing.internal.io.netty.util.concurrent.EventExecutor;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;

final class DefaultBodyPart
implements BodyPart {
    private final HttpHeaders headers;
    private final ByteStreamMessage content;

    DefaultBodyPart(HttpHeaders headers, ByteStreamMessage content) {
        this.headers = headers;
        this.content = content;
    }

    @Override
    public HttpHeaders headers() {
        return this.headers;
    }

    @Override
    public ByteStreamMessage content() {
        return this.content;
    }

    @Override
    public CompletableFuture<Void> writeTo(Path path, EventExecutor eventExecutor, ExecutorService blockingTaskExecutor, OpenOption ... options) {
        return StreamMessages.writeTo((StreamMessage<? extends HttpData>)this.content, path, eventExecutor, blockingTaskExecutor, options);
    }

    @Override
    public CompletableFuture<Void> writeTo(Path path, OpenOption ... options) {
        return StreamMessages.writeTo((StreamMessage<? extends HttpData>)this.content, path, options);
    }

    @Override
    public CompletableFuture<AggregatedBodyPart> aggregate() {
        return this.aggregate0(this.content().defaultSubscriberExecutor(), null);
    }

    @Override
    public CompletableFuture<AggregatedBodyPart> aggregate(EventExecutor executor) {
        Objects.requireNonNull(executor, "executor");
        return this.aggregate0(executor, null);
    }

    @Override
    public CompletableFuture<AggregatedBodyPart> aggregateWithPooledObjects(ByteBufAllocator alloc) {
        Objects.requireNonNull(alloc, "alloc");
        return this.aggregate0(this.content().defaultSubscriberExecutor(), alloc);
    }

    @Override
    public CompletableFuture<AggregatedBodyPart> aggregateWithPooledObjects(EventExecutor executor, ByteBufAllocator alloc) {
        Objects.requireNonNull(executor, "executor");
        Objects.requireNonNull(alloc, "alloc");
        return this.aggregate0(executor, alloc);
    }

    private CompletableFuture<AggregatedBodyPart> aggregate0(EventExecutor executor, @Nullable ByteBufAllocator alloc) {
        CompletableFuture<AggregatedBodyPart> future = new CompletableFuture<AggregatedBodyPart>();
        this.content().subscribe(new ContentAggregator(this.headers, future, alloc), executor);
        return future;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("headers", this.headers).add("content", this.content).toString();
    }

    private static final class ContentAggregator
    extends HttpObjectAggregator<AggregatedBodyPart> {
        private final HttpHeaders headers;

        ContentAggregator(HttpHeaders headers, CompletableFuture<AggregatedBodyPart> future, @Nullable ByteBufAllocator alloc) {
            super(future, alloc);
            this.headers = headers;
        }

        @Override
        protected void onHeaders(HttpHeaders headers) {
        }

        @Override
        protected AggregatedBodyPart onSuccess(HttpData content) {
            return AggregatedBodyPart.of(this.headers, content);
        }

        @Override
        protected void onFailure() {
        }
    }
}

