/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.common.multipart;

import io.opentelemetry.testing.internal.armeria.common.AggregatedHttpObject;
import io.opentelemetry.testing.internal.armeria.common.ContentDisposition;
import io.opentelemetry.testing.internal.armeria.common.HttpData;
import io.opentelemetry.testing.internal.armeria.common.HttpHeaders;
import io.opentelemetry.testing.internal.armeria.common.annotation.Nullable;
import io.opentelemetry.testing.internal.armeria.common.multipart.DefaultAggregatedBodyPart;
import java.util.Objects;

public interface AggregatedBodyPart
extends AggregatedHttpObject {
    public static AggregatedBodyPart of(HttpHeaders headers, HttpData content) {
        Objects.requireNonNull(headers, "headers");
        Objects.requireNonNull(content, "content");
        return new DefaultAggregatedBodyPart(headers, content);
    }

    @Nullable
    default public String name() {
        ContentDisposition contentDisposition = this.headers().contentDisposition();
        if (contentDisposition != null) {
            return contentDisposition.name();
        }
        return null;
    }

    @Nullable
    default public String filename() {
        ContentDisposition contentDisposition = this.headers().contentDisposition();
        if (contentDisposition != null) {
            return contentDisposition.filename();
        }
        return null;
    }
}

