/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.common.logging;

import io.opentelemetry.testing.internal.armeria.common.HttpHeaders;
import io.opentelemetry.testing.internal.armeria.common.RequestContext;
import io.opentelemetry.testing.internal.armeria.common.annotation.Nullable;
import io.opentelemetry.testing.internal.armeria.common.annotation.UnstableApi;
import io.opentelemetry.testing.internal.armeria.common.logging.AbstractLogFormatterBuilder;
import io.opentelemetry.testing.internal.armeria.common.logging.JsonLogFormatter;
import io.opentelemetry.testing.internal.armeria.common.logging.LogFormatter;
import io.opentelemetry.testing.internal.armeria.internal.common.JacksonUtil;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.base.MoreObjects;
import io.opentelemetry.testing.internal.jackson.databind.JsonNode;
import io.opentelemetry.testing.internal.jackson.databind.ObjectMapper;
import java.util.Objects;
import java.util.function.BiFunction;

@UnstableApi
public final class JsonLogFormatterBuilder
extends AbstractLogFormatterBuilder<JsonNode> {
    @Nullable
    private ObjectMapper objectMapper;

    JsonLogFormatterBuilder() {
    }

    public JsonLogFormatterBuilder objectMapper(ObjectMapper objectMapper) {
        this.objectMapper = Objects.requireNonNull(objectMapper, "objectMapper");
        return this;
    }

    public JsonLogFormatterBuilder requestHeadersSanitizer(BiFunction<? super RequestContext, ? super HttpHeaders, ? extends @Nullable JsonNode> requestHeadersSanitizer) {
        return (JsonLogFormatterBuilder)super.requestHeadersSanitizer(requestHeadersSanitizer);
    }

    public JsonLogFormatterBuilder responseHeadersSanitizer(BiFunction<? super RequestContext, ? super HttpHeaders, ? extends @Nullable JsonNode> responseHeadersSanitizer) {
        return (JsonLogFormatterBuilder)super.responseHeadersSanitizer(responseHeadersSanitizer);
    }

    public JsonLogFormatterBuilder requestTrailersSanitizer(BiFunction<? super RequestContext, ? super HttpHeaders, ? extends @Nullable JsonNode> requestTrailersSanitizer) {
        return (JsonLogFormatterBuilder)super.requestTrailersSanitizer(requestTrailersSanitizer);
    }

    public JsonLogFormatterBuilder responseTrailersSanitizer(BiFunction<? super RequestContext, ? super HttpHeaders, ? extends @Nullable JsonNode> responseTrailersSanitizer) {
        return (JsonLogFormatterBuilder)super.responseTrailersSanitizer(responseTrailersSanitizer);
    }

    public JsonLogFormatterBuilder headersSanitizer(BiFunction<? super RequestContext, ? super HttpHeaders, ? extends @Nullable JsonNode> headersSanitizer) {
        return (JsonLogFormatterBuilder)super.headersSanitizer(headersSanitizer);
    }

    public JsonLogFormatterBuilder requestContentSanitizer(BiFunction<? super RequestContext, Object, ? extends @Nullable JsonNode> requestContentSanitizer) {
        return (JsonLogFormatterBuilder)super.requestContentSanitizer(requestContentSanitizer);
    }

    public JsonLogFormatterBuilder responseContentSanitizer(BiFunction<? super RequestContext, Object, ? extends @Nullable JsonNode> responseContentSanitizer) {
        return (JsonLogFormatterBuilder)super.responseContentSanitizer(responseContentSanitizer);
    }

    public JsonLogFormatterBuilder contentSanitizer(BiFunction<? super RequestContext, Object, ? extends @Nullable JsonNode> contentSanitizer) {
        return (JsonLogFormatterBuilder)super.contentSanitizer(contentSanitizer);
    }

    public LogFormatter build() {
        ObjectMapper objectMapper = this.objectMapper != null ? this.objectMapper : JacksonUtil.newDefaultObjectMapper();
        BiFunction defaultHeadersSanitizer = JsonLogFormatterBuilder.defaultSanitizer(objectMapper);
        BiFunction defaultContentSanitizer = JsonLogFormatterBuilder.defaultSanitizer(objectMapper);
        return new JsonLogFormatter(MoreObjects.firstNonNull(this.requestHeadersSanitizer(), defaultHeadersSanitizer), MoreObjects.firstNonNull(this.responseHeadersSanitizer(), defaultHeadersSanitizer), MoreObjects.firstNonNull(this.requestTrailersSanitizer(), defaultHeadersSanitizer), MoreObjects.firstNonNull(this.responseTrailersSanitizer(), defaultHeadersSanitizer), MoreObjects.firstNonNull(this.requestContentSanitizer(), defaultContentSanitizer), MoreObjects.firstNonNull(this.responseContentSanitizer(), defaultContentSanitizer), objectMapper);
    }

    private static <T> BiFunction<? super RequestContext, T, JsonNode> defaultSanitizer(ObjectMapper objectMapper) {
        return (requestContext, obj) -> objectMapper.valueToTree(obj);
    }
}

