/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.common;

import io.opentelemetry.testing.internal.armeria.common.StringMultimap;
import io.opentelemetry.testing.internal.armeria.common.annotation.Nullable;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.base.Preconditions;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.collect.ImmutableList;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.collect.ImmutableSet;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.Stream;

abstract class StringMultimapBuilder<IN_NAME extends CharSequence, NAME extends IN_NAME, CONTAINER extends StringMultimap<IN_NAME, NAME>, SELF> {
    private int sizeHint = 16;
    @Nullable
    private CONTAINER delegate;
    @Nullable
    private CONTAINER parent;

    StringMultimapBuilder() {
    }

    StringMultimapBuilder(CONTAINER parent) {
        this.parent = parent;
    }

    final SELF self() {
        return (SELF)this;
    }

    @Nullable
    final CONTAINER delegate() {
        return this.delegate;
    }

    @Nullable
    final CONTAINER parent() {
        return this.parent;
    }

    final <V extends CONTAINER> V updateParent(V parent) {
        this.parent = (StringMultimap)Objects.requireNonNull(parent, "parent");
        return parent;
    }

    final CONTAINER promoteDelegate() {
        CONTAINER delegate = this.delegate;
        assert (delegate != null);
        this.parent = delegate;
        this.delegate = null;
        return delegate;
    }

    @Nullable
    final CONTAINER getters() {
        if (this.delegate != null) {
            return this.delegate;
        }
        if (this.parent != null) {
            return this.parent;
        }
        return null;
    }

    final CONTAINER setters() {
        if (this.delegate != null) {
            return this.delegate;
        }
        if (this.parent != null) {
            this.delegate = this.newSetters(this.parent, false);
            return this.delegate;
        }
        this.delegate = this.newSetters(this.sizeHint);
        return this.delegate;
    }

    abstract CONTAINER newSetters(int var1);

    abstract CONTAINER newSetters(CONTAINER var1, boolean var2);

    public final SELF sizeHint(int sizeHint) {
        Preconditions.checkArgument(sizeHint >= 0, "sizeHint: %s (expected: >= 0)", sizeHint);
        Preconditions.checkState(this.delegate == null, "sizeHint cannot be specified after a modification is made.");
        this.sizeHint = sizeHint;
        return this.self();
    }

    @Nullable
    public final String get(IN_NAME name) {
        CONTAINER getters = this.getters();
        return getters != null ? ((StringMultimap)getters).get(name) : null;
    }

    public final String get(IN_NAME name, String defaultValue) {
        CONTAINER getters = this.getters();
        return getters != null ? ((StringMultimap)getters).get(name, defaultValue) : Objects.requireNonNull(defaultValue, "defaultValue");
    }

    @Nullable
    public final String getLast(IN_NAME name) {
        CONTAINER getters = this.getters();
        return getters != null ? ((StringMultimap)getters).getLast(name) : null;
    }

    public final String getLast(IN_NAME name, String defaultValue) {
        CONTAINER getters = this.getters();
        return getters != null ? ((StringMultimap)getters).getLast(name, defaultValue) : Objects.requireNonNull(defaultValue, "defaultValue");
    }

    public final List<String> getAll(IN_NAME name) {
        CONTAINER getters = this.getters();
        return getters != null ? ((StringMultimap)getters).getAll(name) : ImmutableList.of();
    }

    @Nullable
    public final Boolean getBoolean(IN_NAME name) {
        CONTAINER getters = this.getters();
        return getters != null ? ((StringMultimap)getters).getBoolean(name) : null;
    }

    public final boolean getBoolean(IN_NAME name, boolean defaultValue) {
        CONTAINER getters = this.getters();
        return getters != null ? ((StringMultimap)getters).getBoolean(name, defaultValue) : defaultValue;
    }

    @Nullable
    public final Boolean getLastBoolean(IN_NAME name) {
        CONTAINER getters = this.getters();
        return getters != null ? ((StringMultimap)getters).getLastBoolean(name) : null;
    }

    public final boolean getLastBoolean(IN_NAME name, boolean defaultValue) {
        CONTAINER getters = this.getters();
        return getters != null ? ((StringMultimap)getters).getLastBoolean(name, defaultValue) : defaultValue;
    }

    @Nullable
    public final Integer getInt(IN_NAME name) {
        CONTAINER getters = this.getters();
        return getters != null ? ((StringMultimap)getters).getInt(name) : null;
    }

    public final int getInt(IN_NAME name, int defaultValue) {
        CONTAINER getters = this.getters();
        return getters != null ? ((StringMultimap)getters).getInt(name, defaultValue) : defaultValue;
    }

    @Nullable
    public final Integer getLastInt(IN_NAME name) {
        CONTAINER getters = this.getters();
        return getters != null ? ((StringMultimap)getters).getLastInt(name) : null;
    }

    public final int getLastInt(IN_NAME name, int defaultValue) {
        CONTAINER getters = this.getters();
        return getters != null ? ((StringMultimap)getters).getLastInt(name, defaultValue) : defaultValue;
    }

    @Nullable
    public final Long getLong(IN_NAME name) {
        CONTAINER getters = this.getters();
        return getters != null ? ((StringMultimap)getters).getLong(name) : null;
    }

    public final long getLong(IN_NAME name, long defaultValue) {
        CONTAINER getters = this.getters();
        return getters != null ? ((StringMultimap)getters).getLong(name, defaultValue) : defaultValue;
    }

    @Nullable
    public final Long getLastLong(IN_NAME name) {
        CONTAINER getters = this.getters();
        return getters != null ? ((StringMultimap)getters).getLastLong(name) : null;
    }

    public final long getLastLong(IN_NAME name, long defaultValue) {
        CONTAINER getters = this.getters();
        return getters != null ? ((StringMultimap)getters).getLastLong(name, defaultValue) : defaultValue;
    }

    @Nullable
    public final Float getFloat(IN_NAME name) {
        CONTAINER getters = this.getters();
        return getters != null ? ((StringMultimap)getters).getFloat(name) : null;
    }

    public final float getFloat(IN_NAME name, float defaultValue) {
        CONTAINER getters = this.getters();
        return getters != null ? ((StringMultimap)getters).getFloat(name, defaultValue) : defaultValue;
    }

    @Nullable
    public final Float getLastFloat(IN_NAME name) {
        CONTAINER getters = this.getters();
        return getters != null ? ((StringMultimap)getters).getLastFloat(name) : null;
    }

    public final float getLastFloat(IN_NAME name, float defaultValue) {
        CONTAINER getters = this.getters();
        return getters != null ? ((StringMultimap)getters).getLastFloat(name, defaultValue) : defaultValue;
    }

    @Nullable
    public final Double getDouble(IN_NAME name) {
        CONTAINER getters = this.getters();
        return getters != null ? ((StringMultimap)getters).getDouble(name) : null;
    }

    public final double getDouble(IN_NAME name, double defaultValue) {
        CONTAINER getters = this.getters();
        return getters != null ? ((StringMultimap)getters).getDouble(name, defaultValue) : defaultValue;
    }

    @Nullable
    public final Double getLastDouble(IN_NAME name) {
        CONTAINER getters = this.getters();
        return getters != null ? ((StringMultimap)getters).getLastDouble(name) : null;
    }

    public final double getLastDouble(IN_NAME name, double defaultValue) {
        CONTAINER getters = this.getters();
        return getters != null ? ((StringMultimap)getters).getLastDouble(name, defaultValue) : defaultValue;
    }

    @Nullable
    public final Long getTimeMillis(IN_NAME name) {
        CONTAINER getters = this.getters();
        return getters != null ? ((StringMultimap)getters).getTimeMillis(name) : null;
    }

    public final long getTimeMillis(IN_NAME name, long defaultValue) {
        CONTAINER getters = this.getters();
        return getters != null ? ((StringMultimap)getters).getTimeMillis(name, defaultValue) : defaultValue;
    }

    @Nullable
    public final Long getLastTimeMillis(IN_NAME name) {
        CONTAINER getters = this.getters();
        return getters != null ? ((StringMultimap)getters).getLastTimeMillis(name) : null;
    }

    public final long getLastTimeMillis(IN_NAME name, long defaultValue) {
        CONTAINER getters = this.getters();
        return getters != null ? ((StringMultimap)getters).getLastTimeMillis(name, defaultValue) : defaultValue;
    }

    public final boolean contains(IN_NAME name) {
        CONTAINER getters = this.getters();
        return getters != null ? ((StringMultimap)getters).contains(name) : false;
    }

    public final boolean contains(IN_NAME name, String value) {
        CONTAINER getters = this.getters();
        return getters != null ? ((StringMultimap)getters).contains(name, value) : false;
    }

    public final boolean containsObject(IN_NAME name, Object value) {
        CONTAINER getters = this.getters();
        return getters != null ? ((StringMultimap)getters).containsObject(name, value) : false;
    }

    public final boolean containsBoolean(IN_NAME name, boolean value) {
        CONTAINER getters = this.getters();
        return getters != null ? ((StringMultimap)getters).containsBoolean(name, value) : false;
    }

    public final boolean containsInt(IN_NAME name, int value) {
        CONTAINER getters = this.getters();
        return getters != null ? ((StringMultimap)getters).containsInt(name, value) : false;
    }

    public final boolean containsLong(IN_NAME name, long value) {
        CONTAINER getters = this.getters();
        return getters != null ? ((StringMultimap)getters).containsLong(name, value) : false;
    }

    public final boolean containsFloat(IN_NAME name, float value) {
        CONTAINER getters = this.getters();
        return getters != null ? ((StringMultimap)getters).containsFloat(name, value) : false;
    }

    public final boolean containsDouble(IN_NAME name, double value) {
        CONTAINER getters = this.getters();
        return getters != null ? ((StringMultimap)getters).containsDouble(name, value) : false;
    }

    public final boolean containsTimeMillis(IN_NAME name, long value) {
        CONTAINER getters = this.getters();
        return getters != null ? ((StringMultimap)getters).containsTimeMillis(name, value) : false;
    }

    public final int size() {
        if (this.delegate != null) {
            return ((StringMultimap)this.delegate).size();
        }
        if (this.parent != null) {
            return ((StringMultimap)this.parent).size();
        }
        return 0;
    }

    public final boolean isEmpty() {
        return this.size() == 0;
    }

    public final Set<NAME> names() {
        CONTAINER getters = this.getters();
        return getters != null ? ((StringMultimap)getters).names() : ImmutableSet.of();
    }

    public final Iterator<Map.Entry<NAME, String>> iterator() {
        CONTAINER getters = this.getters();
        return getters != null ? ((StringMultimap)getters).iterator() : Collections.emptyIterator();
    }

    public final Iterator<String> valueIterator(IN_NAME name) {
        CONTAINER getters = this.getters();
        return getters != null ? ((StringMultimap)getters).valueIterator(name) : Collections.emptyIterator();
    }

    public final void forEach(BiConsumer<NAME, String> action) {
        CONTAINER getters = this.getters();
        if (getters != null) {
            ((StringMultimap)getters).forEach(action);
        }
    }

    public final void forEachValue(IN_NAME name, Consumer<String> action) {
        CONTAINER getters = this.getters();
        if (getters != null) {
            ((StringMultimap)getters).forEachValue(name, action);
        }
    }

    public final Stream<Map.Entry<NAME, String>> stream() {
        CONTAINER getters = this.getters();
        return getters != null ? getters.stream() : Stream.empty();
    }

    public final Stream<String> valueStream(IN_NAME name) {
        CONTAINER getters = this.getters();
        return getters != null ? getters.valueStream(name) : Stream.empty();
    }

    @Nullable
    public final String getAndRemove(IN_NAME name) {
        return this.contains(name) ? ((StringMultimap)this.setters()).getAndRemove(name) : null;
    }

    public final String getAndRemove(IN_NAME name, String defaultValue) {
        return this.contains(name) ? ((StringMultimap)this.setters()).getAndRemove(name, defaultValue) : Objects.requireNonNull(defaultValue, "defaultValue");
    }

    public final List<String> getAllAndRemove(IN_NAME name) {
        return this.contains(name) ? ((StringMultimap)this.setters()).getAllAndRemove(name) : ImmutableList.of();
    }

    @Nullable
    public final Integer getIntAndRemove(IN_NAME name) {
        return this.contains(name) ? ((StringMultimap)this.setters()).getIntAndRemove(name) : null;
    }

    public final int getIntAndRemove(IN_NAME name, int defaultValue) {
        return this.contains(name) ? ((StringMultimap)this.setters()).getIntAndRemove(name, defaultValue) : defaultValue;
    }

    @Nullable
    public final Long getLongAndRemove(IN_NAME name) {
        return this.contains(name) ? ((StringMultimap)this.setters()).getLongAndRemove(name) : null;
    }

    public final long getLongAndRemove(IN_NAME name, long defaultValue) {
        return this.contains(name) ? ((StringMultimap)this.setters()).getLongAndRemove(name, defaultValue) : defaultValue;
    }

    @Nullable
    public final Float getFloatAndRemove(IN_NAME name) {
        return this.contains(name) ? ((StringMultimap)this.setters()).getFloatAndRemove(name) : null;
    }

    public final float getFloatAndRemove(IN_NAME name, float defaultValue) {
        return this.contains(name) ? ((StringMultimap)this.setters()).getFloatAndRemove(name, defaultValue) : defaultValue;
    }

    @Nullable
    public final Double getDoubleAndRemove(IN_NAME name) {
        return this.contains(name) ? ((StringMultimap)this.setters()).getDoubleAndRemove(name) : null;
    }

    public final double getDoubleAndRemove(IN_NAME name, double defaultValue) {
        return this.contains(name) ? ((StringMultimap)this.setters()).getDoubleAndRemove(name, defaultValue) : defaultValue;
    }

    @Nullable
    public final Long getTimeMillisAndRemove(IN_NAME name) {
        return this.contains(name) ? ((StringMultimap)this.setters()).getTimeMillisAndRemove(name) : null;
    }

    public final long getTimeMillisAndRemove(IN_NAME name, long defaultValue) {
        return this.contains(name) ? ((StringMultimap)this.setters()).getTimeMillisAndRemove(name, defaultValue) : defaultValue;
    }

    public final SELF add(IN_NAME name, String value) {
        ((StringMultimap)this.setters()).add(name, value);
        return this.self();
    }

    public final SELF add(IN_NAME name, Iterable<String> values) {
        ((StringMultimap)this.setters()).add(name, values);
        return this.self();
    }

    public final SELF add(IN_NAME name, String ... values) {
        ((StringMultimap)this.setters()).add(name, values);
        return this.self();
    }

    public final SELF add(Iterable<? extends Map.Entry<? extends IN_NAME, String>> entries) {
        ((StringMultimap)this.setters()).add(entries);
        return this.self();
    }

    public final SELF addObject(IN_NAME name, Object value) {
        ((StringMultimap)this.setters()).addObject(name, value);
        return this.self();
    }

    public final SELF addObject(IN_NAME name, Iterable<?> values) {
        ((StringMultimap)this.setters()).addObject(name, values);
        return this.self();
    }

    public final SELF addObject(IN_NAME name, Object ... values) {
        ((StringMultimap)this.setters()).addObject(name, values);
        return this.self();
    }

    public final SELF addObject(Iterable<? extends Map.Entry<? extends IN_NAME, ?>> entries) {
        ((StringMultimap)this.setters()).addObject(entries);
        return this.self();
    }

    public final SELF addInt(IN_NAME name, int value) {
        ((StringMultimap)this.setters()).addInt(name, value);
        return this.self();
    }

    public final SELF addLong(IN_NAME name, long value) {
        ((StringMultimap)this.setters()).addLong(name, value);
        return this.self();
    }

    public final SELF addFloat(IN_NAME name, float value) {
        ((StringMultimap)this.setters()).addFloat(name, value);
        return this.self();
    }

    public final SELF addDouble(IN_NAME name, double value) {
        ((StringMultimap)this.setters()).addDouble(name, value);
        return this.self();
    }

    public final SELF addTimeMillis(IN_NAME name, long value) {
        ((StringMultimap)this.setters()).addTimeMillis(name, value);
        return this.self();
    }

    public final SELF set(IN_NAME name, String value) {
        ((StringMultimap)this.setters()).set(name, value);
        return this.self();
    }

    public final SELF set(IN_NAME name, Iterable<String> values) {
        ((StringMultimap)this.setters()).set(name, values);
        return this.self();
    }

    public final SELF set(IN_NAME name, String ... values) {
        ((StringMultimap)this.setters()).set(name, values);
        return this.self();
    }

    public final SELF set(Iterable<? extends Map.Entry<? extends IN_NAME, String>> entries) {
        ((StringMultimap)this.setters()).set(entries);
        return this.self();
    }

    public final SELF setIfAbsent(Iterable<? extends Map.Entry<? extends IN_NAME, String>> entries) {
        ((StringMultimap)this.setters()).setIfAbsent(entries);
        return this.self();
    }

    public final SELF setObject(IN_NAME name, Object value) {
        ((StringMultimap)this.setters()).setObject(name, value);
        return this.self();
    }

    public final SELF setObject(IN_NAME name, Iterable<?> values) {
        ((StringMultimap)this.setters()).setObject(name, values);
        return this.self();
    }

    public final SELF setObject(IN_NAME name, Object ... values) {
        ((StringMultimap)this.setters()).setObject(name, values);
        return this.self();
    }

    public final SELF setObject(Iterable<? extends Map.Entry<? extends IN_NAME, ?>> entries) {
        ((StringMultimap)this.setters()).setObject(entries);
        return this.self();
    }

    public final SELF setInt(IN_NAME name, int value) {
        ((StringMultimap)this.setters()).setInt(name, value);
        return this.self();
    }

    public final SELF setLong(IN_NAME name, long value) {
        ((StringMultimap)this.setters()).setLong(name, value);
        return this.self();
    }

    public final SELF setFloat(IN_NAME name, float value) {
        ((StringMultimap)this.setters()).setFloat(name, value);
        return this.self();
    }

    public final SELF setDouble(IN_NAME name, double value) {
        ((StringMultimap)this.setters()).setDouble(name, value);
        return this.self();
    }

    public final SELF setTimeMillis(IN_NAME name, long value) {
        ((StringMultimap)this.setters()).setTimeMillis(name, value);
        return this.self();
    }

    public final boolean remove(IN_NAME name) {
        return this.contains(name) ? ((StringMultimap)this.setters()).remove(name) : false;
    }

    public final SELF removeAndThen(IN_NAME name) {
        if (this.contains(name)) {
            ((StringMultimap)this.setters()).remove(name);
        }
        return this.self();
    }

    public final SELF clear() {
        if (!this.isEmpty()) {
            ((StringMultimap)this.setters()).clear();
        }
        return this.self();
    }

    public int hashCode() {
        CONTAINER getters = this.getters();
        if (getters != null) {
            return ((StringMultimap)getters).hashCode();
        }
        return -1028477387;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof StringMultimapBuilder)) {
            return false;
        }
        StringMultimapBuilder that = (StringMultimapBuilder)o;
        if (this.size() != that.size()) {
            return false;
        }
        if (this.isEmpty() && that.isEmpty()) {
            return true;
        }
        CONTAINER getters = this.getters();
        if (getters != null) {
            return ((StringMultimap)getters).equals(that.getters());
        }
        return false;
    }

    public final String toString() {
        CONTAINER getters = this.getters();
        if (getters != null) {
            return ((StringMultimap)getters).toString();
        }
        return "[]";
    }
}

