/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.common;

import io.opentelemetry.testing.internal.armeria.common.Flags;
import io.opentelemetry.testing.internal.armeria.common.RequestTargetForm;
import io.opentelemetry.testing.internal.armeria.common.annotation.Nullable;
import io.opentelemetry.testing.internal.armeria.common.annotation.UnstableApi;
import io.opentelemetry.testing.internal.armeria.internal.common.DefaultRequestTarget;
import io.opentelemetry.testing.internal.armeria.internal.common.util.TemporaryThreadLocals;
import java.util.Objects;

@UnstableApi
public interface RequestTarget {
    @Nullable
    public static RequestTarget forServer(String reqTarget) {
        Objects.requireNonNull(reqTarget, "reqTarget");
        return DefaultRequestTarget.forServer(reqTarget, Flags.allowSemicolonInPathComponent(), Flags.allowDoubleDotsInQueryString());
    }

    @Nullable
    public static RequestTarget forClient(String reqTarget) {
        return RequestTarget.forClient(reqTarget, null);
    }

    @Nullable
    public static RequestTarget forClient(String reqTarget, @Nullable String prefix) {
        return DefaultRequestTarget.forClient(reqTarget, prefix);
    }

    public RequestTargetForm form();

    @Nullable
    public String scheme();

    @Nullable
    public String authority();

    public String path();

    public String maybePathWithMatrixVariables();

    @Nullable
    public String query();

    default public String pathAndQuery() {
        if (this.query() == null) {
            return this.path();
        }
        try (TemporaryThreadLocals tmp = TemporaryThreadLocals.acquire();){
            String string = tmp.stringBuilder().append(this.path()).append('?').append(this.query()).toString();
            return string;
        }
    }

    @Nullable
    public String fragment();

    public String toString();
}

