/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.common;

import io.opentelemetry.testing.internal.armeria.common.DefaultRequestEntity;
import io.opentelemetry.testing.internal.armeria.common.HttpEntity;
import io.opentelemetry.testing.internal.armeria.common.HttpHeaders;
import io.opentelemetry.testing.internal.armeria.common.HttpMethod;
import io.opentelemetry.testing.internal.armeria.common.RequestHeaders;
import io.opentelemetry.testing.internal.armeria.common.annotation.Nullable;
import io.opentelemetry.testing.internal.armeria.common.annotation.UnstableApi;
import java.util.Objects;

@UnstableApi
public interface RequestEntity<T>
extends HttpEntity<T> {
    public static RequestEntity<Void> of(RequestHeaders headers) {
        return RequestEntity.of(headers, null, HttpHeaders.of());
    }

    public static <T> RequestEntity<T> of(RequestHeaders headers, T content) {
        Objects.requireNonNull(content, "content");
        return RequestEntity.of(headers, content, HttpHeaders.of());
    }

    public static <T> RequestEntity<T> of(RequestHeaders headers, @Nullable T content, HttpHeaders trailers) {
        Objects.requireNonNull(headers, "headers");
        Objects.requireNonNull(trailers, "trailers");
        return new DefaultRequestEntity<T>(headers, content, trailers);
    }

    @Override
    public RequestHeaders headers();

    default public HttpMethod method() {
        return this.headers().method();
    }
}

