/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.common;

import io.opentelemetry.testing.internal.armeria.common.MediaType;
import io.opentelemetry.testing.internal.armeria.common.annotation.Nullable;
import io.opentelemetry.testing.internal.jackson.core.JsonParser;
import io.opentelemetry.testing.internal.jackson.databind.DeserializationContext;
import io.opentelemetry.testing.internal.jackson.databind.JsonNode;
import io.opentelemetry.testing.internal.jackson.databind.deser.std.StdDeserializer;
import java.io.IOException;

final class MediaTypeJsonDeserializer
extends StdDeserializer<MediaType> {
    private static final long serialVersionUID = 2081299438299133097L;

    MediaTypeJsonDeserializer() {
        super(MediaType.class);
    }

    @Override
    @Nullable
    public MediaType deserialize(JsonParser p, DeserializationContext ctx) throws IOException {
        JsonNode tree = (JsonNode)p.getCodec().readTree(p);
        if (!tree.isTextual()) {
            ctx.reportInputMismatch(MediaType.class, "media type must be a string.", new Object[0]);
            return null;
        }
        String textValue = tree.textValue();
        try {
            return MediaType.parse(textValue);
        }
        catch (IllegalArgumentException unused) {
            ctx.reportInputMismatch(MediaType.class, "malformed media type: " + textValue, new Object[0]);
            return null;
        }
    }
}

