/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.common;

import io.opentelemetry.testing.internal.armeria.common.DeferredHttpResponse;
import io.opentelemetry.testing.internal.armeria.common.HttpResponse;
import io.opentelemetry.testing.internal.armeria.common.util.Exceptions;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;

final class HttpResponseUtil {
    static HttpResponse createHttpResponseFrom(CompletableFuture<? extends HttpResponse> future) {
        Objects.requireNonNull(future, "future");
        if (future.isDone()) {
            if (!future.isCompletedExceptionally()) {
                return future.getNow(null);
            }
            try {
                future.join();
                throw new Error();
            }
            catch (Throwable cause) {
                return HttpResponse.ofFailure(Exceptions.peel(cause));
            }
        }
        DeferredHttpResponse res = new DeferredHttpResponse();
        res.delegateWhenComplete(future);
        return res;
    }

    private HttpResponseUtil() {
    }
}

