/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.common;

import io.opentelemetry.testing.internal.armeria.common.AggregatedHttpRequest;
import io.opentelemetry.testing.internal.armeria.common.AggregationOptions;
import io.opentelemetry.testing.internal.armeria.common.HttpData;
import io.opentelemetry.testing.internal.armeria.common.HttpObject;
import io.opentelemetry.testing.internal.armeria.common.HttpRequest;
import io.opentelemetry.testing.internal.armeria.common.HttpRequestDuplicator;
import io.opentelemetry.testing.internal.armeria.common.RequestHeaders;
import io.opentelemetry.testing.internal.armeria.common.stream.DefaultStreamMessageDuplicator;
import io.opentelemetry.testing.internal.armeria.common.stream.StreamMessage;
import io.opentelemetry.testing.internal.armeria.common.stream.StreamMessageWrapper;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.base.MoreObjects;
import io.opentelemetry.testing.internal.io.netty.util.concurrent.EventExecutor;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;

final class DefaultHttpRequestDuplicator
extends DefaultStreamMessageDuplicator<HttpObject>
implements HttpRequestDuplicator {
    private final RequestHeaders headers;

    DefaultHttpRequestDuplicator(HttpRequest req, EventExecutor executor, long maxRequestLength) {
        super(Objects.requireNonNull(req, "req"), obj -> {
            if (obj instanceof HttpData) {
                return ((HttpData)obj).length();
            }
            return 0;
        }, executor, maxRequestLength);
        this.headers = req.headers();
    }

    @Override
    public RequestHeaders headers() {
        return this.headers;
    }

    @Override
    public HttpRequest duplicate() {
        return this.duplicate(this.headers);
    }

    @Override
    public HttpRequest duplicate(RequestHeaders newHeaders) {
        Objects.requireNonNull(newHeaders, "newHeaders");
        return new DuplicatedHttpRequest(super.duplicate(), newHeaders);
    }

    private class DuplicatedHttpRequest
    extends StreamMessageWrapper<HttpObject>
    implements HttpRequest {
        private final RequestHeaders headers;

        DuplicatedHttpRequest(StreamMessage<? extends HttpObject> delegate, RequestHeaders headers) {
            super(delegate);
            this.headers = headers;
        }

        @Override
        public RequestHeaders headers() {
            return this.headers;
        }

        @Override
        public CompletableFuture<AggregatedHttpRequest> aggregate(AggregationOptions options) {
            return super.aggregate(options);
        }

        @Override
        public HttpRequestDuplicator toDuplicator() {
            return this.toDuplicator(DefaultHttpRequestDuplicator.this.duplicatorExecutor());
        }

        @Override
        public HttpRequestDuplicator toDuplicator(EventExecutor executor) {
            return HttpRequest.super.toDuplicator(executor);
        }

        @Override
        public EventExecutor defaultSubscriberExecutor() {
            return DefaultHttpRequestDuplicator.this.duplicatorExecutor();
        }

        @Override
        public String toString() {
            return MoreObjects.toStringHelper(this).add("headers", this.headers).toString();
        }
    }
}

