/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.common;

import io.opentelemetry.testing.internal.armeria.common.ContextAwareRunnable;
import io.opentelemetry.testing.internal.armeria.common.RequestContext;
import io.opentelemetry.testing.internal.armeria.common.util.SafeCloseable;
import java.util.Objects;

final class DefaultContextAwareRunnable
implements ContextAwareRunnable {
    private final RequestContext context;
    private final Runnable runnable;

    DefaultContextAwareRunnable(RequestContext context, Runnable runnable) {
        this.context = Objects.requireNonNull(context, "context");
        this.runnable = Objects.requireNonNull(runnable, "runnable");
    }

    @Override
    public RequestContext context() {
        return this.context;
    }

    @Override
    public Runnable withoutContext() {
        return this.runnable;
    }

    @Override
    public void run() {
        try (SafeCloseable ignored = this.context.push();){
            this.runnable.run();
        }
    }
}

