/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.common;

import io.opentelemetry.testing.internal.armeria.common.ContextAwareFunction;
import io.opentelemetry.testing.internal.armeria.common.RequestContext;
import io.opentelemetry.testing.internal.armeria.common.util.SafeCloseable;
import java.util.Objects;
import java.util.function.Function;

final class DefaultContextAwareFunction<T, R>
implements ContextAwareFunction<T, R> {
    private final RequestContext context;
    private final Function<T, R> function;

    DefaultContextAwareFunction(RequestContext context, Function<T, R> function) {
        this.context = Objects.requireNonNull(context, "context");
        this.function = Objects.requireNonNull(function, "function");
    }

    @Override
    public RequestContext context() {
        return this.context;
    }

    @Override
    public Function<T, R> withoutContext() {
        return this.function;
    }

    @Override
    public R apply(T t) {
        try (SafeCloseable ignored = this.context.push();){
            R r = this.function.apply(t);
            return r;
        }
    }
}

