/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.common;

import io.opentelemetry.testing.internal.armeria.common.ContextAwareConsumer;
import io.opentelemetry.testing.internal.armeria.common.RequestContext;
import io.opentelemetry.testing.internal.armeria.common.util.SafeCloseable;
import java.util.Objects;
import java.util.function.Consumer;

final class DefaultContextAwareConsumer<T>
implements ContextAwareConsumer<T> {
    private final RequestContext context;
    private final Consumer<T> action;

    DefaultContextAwareConsumer(RequestContext context, Consumer<T> action) {
        this.context = Objects.requireNonNull(context, "context");
        this.action = Objects.requireNonNull(action, "action");
    }

    @Override
    public RequestContext context() {
        return this.context;
    }

    @Override
    public Consumer<T> withoutContext() {
        return this.action;
    }

    @Override
    public void accept(T t) {
        try (SafeCloseable ignored = this.context.push();){
            this.action.accept(t);
        }
    }
}

