/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.common;

import io.opentelemetry.testing.internal.armeria.common.ContextAwareCallable;
import io.opentelemetry.testing.internal.armeria.common.RequestContext;
import io.opentelemetry.testing.internal.armeria.common.util.SafeCloseable;
import java.util.Objects;
import java.util.concurrent.Callable;

final class DefaultContextAwareCallable<T>
implements ContextAwareCallable<T> {
    private final RequestContext context;
    private final Callable<T> callable;

    DefaultContextAwareCallable(RequestContext context, Callable<T> callable) {
        this.context = Objects.requireNonNull(context, "context");
        this.callable = Objects.requireNonNull(callable, "callable");
    }

    @Override
    public RequestContext context() {
        return this.context;
    }

    @Override
    public Callable<T> withoutContext() {
        return this.callable;
    }

    @Override
    public T call() throws Exception {
        try (SafeCloseable ignored = this.context.push();){
            T t = this.callable.call();
            return t;
        }
    }
}

