/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.common;

import io.opentelemetry.testing.internal.armeria.common.ContextHolder;
import io.opentelemetry.testing.internal.armeria.common.DefaultContextAwareExecutor;
import io.opentelemetry.testing.internal.armeria.common.RequestContext;
import io.opentelemetry.testing.internal.armeria.internal.common.RequestContextUtil;
import java.util.Objects;
import java.util.concurrent.Executor;

public interface ContextAwareExecutor
extends ContextHolder,
Executor {
    public static ContextAwareExecutor of(RequestContext context, Executor executor) {
        Objects.requireNonNull(context, "context");
        Objects.requireNonNull(executor, "executor");
        if (executor instanceof ContextAwareExecutor) {
            RequestContextUtil.ensureSameCtx(context, (ContextAwareExecutor)executor, ContextAwareExecutor.class);
            return (ContextAwareExecutor)executor;
        }
        return new DefaultContextAwareExecutor(context, executor);
    }

    @Override
    public RequestContext context();

    public Executor withoutContext();
}

