/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.common;

import io.opentelemetry.testing.internal.armeria.common.Flags;
import io.opentelemetry.testing.internal.armeria.common.metric.MoreMeterBinders;
import io.opentelemetry.testing.internal.armeria.common.util.BlockingTaskExecutor;
import io.opentelemetry.testing.internal.armeria.common.util.EventLoopGroups;
import io.opentelemetry.testing.internal.io.netty.channel.EventLoopGroup;

public final class CommonPools {
    private static final BlockingTaskExecutor BLOCKING_TASK_EXECUTOR = BlockingTaskExecutor.builder().threadNamePrefix("armeria-common-blocking-tasks").build();
    private static final EventLoopGroup WORKER_GROUP = EventLoopGroups.newEventLoopGroup(Flags.numCommonWorkers(), "armeria-common-worker", true);

    public static BlockingTaskExecutor blockingTaskExecutor() {
        return BLOCKING_TASK_EXECUTOR;
    }

    public static EventLoopGroup workerGroup() {
        return WORKER_GROUP;
    }

    private CommonPools() {
    }

    static {
        MoreMeterBinders.eventLoopMetrics(WORKER_GROUP, "common").bindTo(Flags.meterRegistry());
    }
}

